/*
 * Decompiled with CFR 0.152.
 */
package cn.aigestudio.datepicker.bizs.calendars;

import android.text.TextUtils;
import cn.aigestudio.datepicker.bizs.calendars.DPCNCalendar;
import cn.aigestudio.datepicker.bizs.calendars.DPCalendar;
import cn.aigestudio.datepicker.bizs.calendars.DPUSCalendar;
import cn.aigestudio.datepicker.entities.DPInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class DPCManager {
    private static final HashMap<Integer, HashMap<Integer, DPInfo[][]>> DATE_CACHE = new HashMap();
    private static final HashMap<String, Set<String>> DECOR_CACHE_BG = new HashMap();
    private static final HashMap<String, Set<String>> DECOR_CACHE_TL = new HashMap();
    private static final HashMap<String, Set<String>> DECOR_CACHE_T = new HashMap();
    private static final HashMap<String, Set<String>> DECOR_CACHE_TR = new HashMap();
    private static final HashMap<String, Set<String>> DECOR_CACHE_L = new HashMap();
    private static final HashMap<String, Set<String>> DECOR_CACHE_R = new HashMap();
    private static DPCManager sManager;
    private DPCalendar c;

    private DPCManager() {
        String locale = Locale.getDefault().getCountry().toLowerCase();
        if (locale.equals("cn")) {
            this.initCalendar(new DPCNCalendar());
        } else {
            this.initCalendar(new DPUSCalendar());
        }
    }

    public static DPCManager getInstance() {
        if (null == sManager) {
            sManager = new DPCManager();
        }
        return sManager;
    }

    public void initCalendar(DPCalendar c) {
        this.c = c;
    }

    public void setDecorBG(List<String> date) {
        this.setDecor(date, DECOR_CACHE_BG);
    }

    public void setDecorTL(List<String> date) {
        this.setDecor(date, DECOR_CACHE_TL);
    }

    public void setDecorT(List<String> date) {
        this.setDecor(date, DECOR_CACHE_T);
    }

    public void setDecorTR(List<String> date) {
        this.setDecor(date, DECOR_CACHE_TR);
    }

    public void setDecorL(List<String> date) {
        this.setDecor(date, DECOR_CACHE_L);
    }

    public void setDecorR(List<String> date) {
        this.setDecor(date, DECOR_CACHE_R);
    }

    public DPInfo[][] obtainDPInfo(int year, int month) {
        HashMap<Integer, Object> dataOfYear = DATE_CACHE.get(year);
        if (null != dataOfYear && dataOfYear.size() != 0) {
            DPInfo[][] dataOfMonth = dataOfYear.get(month);
            if (dataOfMonth != null) {
                return dataOfMonth;
            }
            dataOfMonth = this.buildDPInfo(year, month);
            dataOfYear.put(month, dataOfMonth);
            return dataOfMonth;
        }
        if (null == dataOfYear) {
            dataOfYear = new HashMap();
        }
        DPInfo[][] dataOfMonth = this.buildDPInfo(year, month);
        dataOfYear.put(month, dataOfMonth);
        DATE_CACHE.put(year, dataOfYear);
        return dataOfMonth;
    }

    private void setDecor(List<String> date, HashMap<String, Set<String>> cache) {
        for (String str : date) {
            int index;
            String key = str.substring(0, index = str.lastIndexOf("-")).replace("-", ":");
            Set<String> days = cache.get(key);
            if (null == days) {
                days = new HashSet<String>();
            }
            days.add(str.substring(index + 1, str.length()));
            cache.put(key, days);
        }
    }

    private DPInfo[][] buildDPInfo(int year, int month) {
        DPInfo[][] info = new DPInfo[6][7];
        String[][] strG = this.c.buildMonthG(year, month);
        String[][] strF = this.c.buildMonthFestival(year, month);
        Set<String> strHoliday = this.c.buildMonthHoliday(year, month);
        Set<String> strWeekend = this.c.buildMonthWeekend(year, month);
        Set<String> decorBG = DECOR_CACHE_BG.get(year + ":" + month);
        Set<String> decorTL = DECOR_CACHE_TL.get(year + ":" + month);
        Set<String> decorT = DECOR_CACHE_T.get(year + ":" + month);
        Set<String> decorTR = DECOR_CACHE_TR.get(year + ":" + month);
        Set<String> decorL = DECOR_CACHE_L.get(year + ":" + month);
        Set<String> decorR = DECOR_CACHE_R.get(year + ":" + month);
        for (int i = 0; i < info.length; ++i) {
            for (int j = 0; j < info[i].length; ++j) {
                DPInfo tmp = new DPInfo();
                tmp.strG = strG[i][j];
                tmp.strF = this.c instanceof DPCNCalendar ? strF[i][j].replace("F", "") : strF[i][j];
                if (!TextUtils.isEmpty((CharSequence)tmp.strG) && strHoliday.contains(tmp.strG)) {
                    tmp.isHoliday = true;
                }
                if (!TextUtils.isEmpty((CharSequence)tmp.strG)) {
                    tmp.isToday = this.c.isToday(year, month, Integer.valueOf(tmp.strG));
                }
                if (strWeekend.contains(tmp.strG)) {
                    tmp.isWeekend = true;
                }
                if (this.c instanceof DPCNCalendar) {
                    if (!TextUtils.isEmpty((CharSequence)tmp.strG)) {
                        tmp.isSolarTerms = ((DPCNCalendar)this.c).isSolarTerm(year, month, Integer.valueOf(tmp.strG));
                    }
                    if (!TextUtils.isEmpty((CharSequence)strF[i][j]) && strF[i][j].endsWith("F")) {
                        tmp.isFestival = true;
                    }
                    if (!TextUtils.isEmpty((CharSequence)tmp.strG)) {
                        tmp.isDeferred = ((DPCNCalendar)this.c).isDeferred(year, month, Integer.valueOf(tmp.strG));
                    }
                } else {
                    boolean bl = tmp.isFestival = !TextUtils.isEmpty((CharSequence)strF[i][j]);
                }
                if (null != decorBG && decorBG.contains(tmp.strG)) {
                    tmp.isDecorBG = true;
                }
                if (null != decorTL && decorTL.contains(tmp.strG)) {
                    tmp.isDecorTL = true;
                }
                if (null != decorT && decorT.contains(tmp.strG)) {
                    tmp.isDecorT = true;
                }
                if (null != decorTR && decorTR.contains(tmp.strG)) {
                    tmp.isDecorTR = true;
                }
                if (null != decorL && decorL.contains(tmp.strG)) {
                    tmp.isDecorL = true;
                }
                if (null != decorR && decorR.contains(tmp.strG)) {
                    tmp.isDecorR = true;
                }
                info[i][j] = tmp;
            }
        }
        return info;
    }
}

