/*
 * Decompiled with CFR 0.152.
 */
package cn.lemon.view;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.support.annotation.ColorInt;
import android.support.annotation.IdRes;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

public class GuideView
extends RelativeLayout {
    private final String TAG = "GuideView";
    private boolean hasMeasure = false;
    private boolean hasAddHintView = false;
    private boolean isShowing = false;
    private int[] mTargetViewLocation = new int[2];
    private int mTargetViewWidth;
    private int mTargetViewHeight;
    private int mScreenWidth;
    private int mScreenHeight;
    private Paint mBackgroundPaint;
    private Paint mTransparentPaint;
    private ViewGroup mDecorView;
    private Builder.GuideViewParams mParams;

    public GuideView(Context context) {
        this(context, null);
    }

    public GuideView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GuideView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (!(context instanceof Activity)) {
            throw new IllegalArgumentException("context must be activity");
        }
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.mScreenWidth = displayMetrics.widthPixels;
        this.mScreenHeight = displayMetrics.heightPixels;
        this.mDecorView = (ViewGroup)((Activity)this.getContext()).getWindow().getDecorView();
        this.setWillNotDraw(false);
        Log.i((String)"GuideView", (String)("screenWidth : " + this.mScreenWidth + "  screenHeight : " + this.mScreenHeight));
    }

    public void initParams(Builder.GuideViewParams params) {
        this.mParams = params;
        this.mBackgroundPaint = new Paint();
        this.mTransparentPaint = new Paint();
        this.mBackgroundPaint.setColor(this.mParams.maskLayerColor);
        this.setOnClickListener(this.mParams.mClickListener);
    }

    protected void onDraw(Canvas canvas) {
        Bitmap bitmap = Bitmap.createBitmap((int)canvas.getWidth(), (int)canvas.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas mTemp = new Canvas(bitmap);
        mTemp.drawRect(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight(), this.mBackgroundPaint);
        PorterDuffXfermode mDrawMode = new PorterDuffXfermode(PorterDuff.Mode.SRC_OUT);
        this.mTransparentPaint.setXfermode((Xfermode)mDrawMode);
        this.mTransparentPaint.setAntiAlias(true);
        RectF rectF = new RectF((float)(this.mTargetViewLocation[0] - this.mParams.mTransparentPaddingLeft + this.mParams.mTransparentMarginLeft), (float)(this.mTargetViewLocation[1] - this.mParams.mTransparentPaddingTop + this.mParams.mTransparentMarginTop), (float)(this.mTargetViewLocation[0] + this.mTargetViewWidth + this.mParams.mTransparentPaddingRight - this.mParams.mTransparentMarginRight), (float)(this.mTargetViewLocation[1] + this.mTargetViewHeight + this.mParams.mTransparentPaddingBottom - this.mParams.mTransparentMarginBottom));
        mTemp.drawOval(rectF, this.mTransparentPaint);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, this.mBackgroundPaint);
    }

    @SuppressLint(value={"RtlHardcoded"})
    private void addHintView() {
        if (this.hasAddHintView) {
            return;
        }
        if (this.mParams.mHintView != null) {
            RelativeLayout.LayoutParams layoutParams = this.mParams.mHintLayoutParams != null ? this.mParams.mHintLayoutParams : new RelativeLayout.LayoutParams(-2, -2);
            switch (this.mParams.mDirection) {
                case 10: {
                    this.setGravity(5);
                    layoutParams.setMargins(0, this.mTargetViewLocation[1], this.mScreenWidth - this.mTargetViewLocation[0] + this.mParams.mHintViewSpace + this.mParams.mHintViewMarginRight, 0);
                    break;
                }
                case 12: {
                    this.setGravity(53);
                    layoutParams.setMargins(0, this.mTargetViewLocation[1] + this.mTargetViewHeight + this.mParams.mHintViewSpace + this.mParams.mHintViewMarginTop, this.mScreenWidth - this.mTargetViewLocation[0] + this.mParams.mHintViewSpace + this.mParams.mHintViewMarginRight, 0);
                    break;
                }
                case 11: {
                    this.setGravity(85);
                    layoutParams.setMargins(0, 0, this.mScreenWidth - this.mTargetViewLocation[0] + this.mParams.mHintViewSpace + this.mParams.mHintViewMarginRight, this.mScreenHeight - this.mTargetViewLocation[1] + this.mParams.mHintViewSpace + this.mParams.mHintViewMarginBottom);
                    break;
                }
                case 13: {
                    this.setGravity(85);
                    layoutParams.setMargins(0, this.mTargetViewLocation[1], this.mScreenWidth - this.mTargetViewLocation[0] + this.mParams.mHintViewSpace + this.mParams.mHintViewMarginRight, this.mScreenHeight - this.mTargetViewLocation[1] - this.mTargetViewHeight);
                    break;
                }
                case 20: {
                    this.setGravity(3);
                    layoutParams.setMargins(this.mTargetViewLocation[0] + this.mTargetViewWidth + this.mParams.mHintViewSpace + this.mParams.mHintViewMarginLeft, this.mTargetViewLocation[1], 0, 0);
                    break;
                }
                case 21: {
                    this.setGravity(83);
                    layoutParams.setMargins(this.mTargetViewWidth + this.mTargetViewLocation[0] + this.mParams.mHintViewSpace + this.mParams.mHintViewMarginLeft, 0, 0, this.mScreenHeight - this.mTargetViewLocation[1] + this.mParams.mHintViewSpace + this.mParams.mHintViewMarginBottom);
                    break;
                }
                case 22: {
                    this.setGravity(51);
                    layoutParams.setMargins(this.mTargetViewLocation[0] + this.mTargetViewWidth + this.mParams.mHintViewSpace + this.mParams.mHintViewMarginLeft, this.mTargetViewLocation[1] + this.mTargetViewHeight + this.mParams.mHintViewSpace + this.mParams.mHintViewMarginTop, 0, 0);
                    break;
                }
                case 23: {
                    this.setGravity(83);
                    layoutParams.setMargins(this.mTargetViewLocation[0] + this.mTargetViewWidth + this.mParams.mHintViewSpace + this.mParams.mHintViewMarginLeft, 0, 0, this.mScreenHeight - this.mTargetViewLocation[1] - this.mTargetViewHeight + this.mParams.mHintViewMarginBottom);
                    break;
                }
                case 30: {
                    this.setGravity(80);
                    layoutParams.setMargins(0, 0, 0, this.mScreenHeight - this.mTargetViewLocation[1] + this.mParams.mHintViewSpace + this.mParams.mHintViewMarginBottom);
                    break;
                }
                case 31: {
                    this.setGravity(83);
                    layoutParams.setMargins(this.mTargetViewLocation[0] + this.mParams.mHintViewMarginLeft, 0, 0, this.mScreenHeight - this.mTargetViewLocation[1] + this.mParams.mHintViewSpace + this.mParams.mHintViewMarginBottom);
                    break;
                }
                case 32: {
                    this.setGravity(85);
                    layoutParams.setMargins(0, 0, this.mScreenWidth - this.mTargetViewLocation[0] - this.mTargetViewWidth + this.mParams.mHintViewMarginRight, this.mScreenHeight - this.mTargetViewLocation[1] + this.mParams.mHintViewSpace + this.mParams.mHintViewMarginBottom);
                    break;
                }
                case 40: {
                    this.setGravity(48);
                    layoutParams.setMargins(0, this.mTargetViewLocation[1] + this.mTargetViewHeight + this.mParams.mHintViewMarginTop, 0, 0);
                    break;
                }
                case 41: {
                    this.setGravity(51);
                    layoutParams.setMargins(this.mTargetViewLocation[0] + this.mParams.mHintViewMarginLeft, this.mTargetViewLocation[1] + this.mTargetViewHeight + this.mParams.mHintViewSpace + this.mParams.mHintViewMarginTop, 0, 0);
                    break;
                }
                case 42: {
                    this.setGravity(53);
                    layoutParams.setMargins(0, this.mTargetViewLocation[1] + this.mTargetViewHeight + this.mParams.mHintViewSpace + this.mParams.mHintViewMarginTop, this.mScreenWidth - this.mTargetViewLocation[0] - this.mTargetViewWidth + this.mParams.mHintViewMarginRight, 0);
                }
            }
            this.addView(this.mParams.mHintView, (ViewGroup.LayoutParams)layoutParams);
            this.hasAddHintView = true;
        }
    }

    private void getTargetViewPosition() {
        Log.i((String)"GuideView", (String)"getTargetViewPosition");
        if (this.mParams.mTargetView.getWidth() > 0 && this.mParams.mTargetView.getHeight() > 0) {
            this.mParams.mTargetView.getLocationInWindow(this.mTargetViewLocation);
            if (this.mTargetViewWidth == 0 || this.mTargetViewHeight == 0) {
                this.mTargetViewWidth = this.mParams.mTargetView.getWidth();
                this.mTargetViewHeight = this.mParams.mTargetView.getHeight();
            }
            if (this.mTargetViewLocation[0] >= 0 && this.mTargetViewLocation[1] > 0) {
                this.hasMeasure = true;
            }
        } else {
            this.hasMeasure = false;
            Log.i((String)"GuideView", (String)"targetView is not measured, please user view.post(Runnable run) initialize GuideView");
        }
    }

    public void show() {
        if (this.isShowing || !this.hasMeasure) {
            return;
        }
        this.addHintView();
        this.mDecorView.addView((View)this);
        this.isShowing = true;
    }

    public void hide() {
        this.removeAllViews();
        this.mDecorView.removeView((View)this);
    }

    public boolean isShowing() {
        return this.isShowing;
    }

    public static class Builder {
        private GuideViewParams mParams;
        private Context mContext;

        public Builder(Context ctx) {
            if (!(ctx instanceof Activity)) {
                throw new IllegalArgumentException("context must be activity and not null");
            }
            this.mParams = new GuideViewParams();
            this.mContext = ctx;
        }

        public Builder setTargetView(View targetView) {
            if (targetView == null) {
                throw new NullPointerException("targetView is null");
            }
            this.mParams.mTargetView = targetView;
            return this;
        }

        public Builder setTargetView(@IdRes int resId) {
            this.mParams.mTargetView = ((Activity)this.mContext).findViewById(resId);
            return this;
        }

        public Builder setHintView(View hintView) {
            this.mParams.mHintView = hintView;
            return this;
        }

        public Builder setHintViewDirection(int direction) {
            this.mParams.mDirection = direction;
            return this;
        }

        public Builder setTransparentOvalPadding(int px) {
            this.mParams.mTransparentPadding = px;
            return this;
        }

        public Builder setTransparentOvalPaddingLeft(int px) {
            this.mParams.mTransparentPaddingLeft = px;
            return this;
        }

        public Builder setTransparentOvalPaddingRight(int px) {
            this.mParams.mTransparentPaddingRight = px;
            return this;
        }

        public Builder setTransparentOvalPaddingTop(int px) {
            this.mParams.mTransparentPaddingTop = px;
            return this;
        }

        public Builder setTransparentOvalPaddingBottom(int px) {
            this.mParams.mTransparentPaddingBottom = px;
            return this;
        }

        public Builder setTransparentMargin(int px) {
            this.mParams.mTransparentMargin = px;
            return this;
        }

        public Builder setTransparentMarginLeft(int mTransparentMarginLeft) {
            this.mParams.mTransparentMarginLeft = mTransparentMarginLeft;
            return this;
        }

        public Builder setTransparentMarginRight(int mTransparentMarginRight) {
            this.mParams.mTransparentMarginRight = mTransparentMarginRight;
            return this;
        }

        public Builder setTransparentMarginTop(int mTransparentMarginTop) {
            this.mParams.mTransparentMarginTop = mTransparentMarginTop;
            return this;
        }

        public Builder setTransparentMarginBottom(int mTransparentMarginBottom) {
            this.mParams.mTransparentMarginBottom = mTransparentMarginBottom;
            return this;
        }

        public Builder setHintViewMargin(int px) {
            this.mParams.mHintViewMargin = px;
            return this;
        }

        public Builder setHintViewMarginLeft(int px) {
            this.mParams.mHintViewMarginLeft = px;
            return this;
        }

        public Builder setHintViewMarginRight(int px) {
            this.mParams.mHintViewMarginRight = px;
            return this;
        }

        public Builder setHintViewMarginTop(int px) {
            this.mParams.mHintViewMarginTop = px;
            return this;
        }

        public Builder setHintViewMarginBottom(int px) {
            this.mParams.mHintViewMarginBottom = px;
            return this;
        }

        public Builder setHintViewSpace(int px) {
            this.mParams.mHintViewSpace = px;
            return this;
        }

        public Builder setBackgroundColor(@ColorInt int color) {
            this.mParams.maskLayerColor = color;
            return this;
        }

        public Builder setHintLayoutParams(RelativeLayout.LayoutParams mHintLayoutParams) {
            this.mParams.mHintLayoutParams = mHintLayoutParams;
            return this;
        }

        public Builder setOnClickListener(View.OnClickListener listener) {
            this.mParams.mClickListener = listener;
            return this;
        }

        public GuideView create() {
            if (this.mParams.mTargetView == null) {
                throw new RuntimeException("please set a targetView");
            }
            GuideView guideView = new GuideView(this.mContext);
            guideView.initParams(this.mParams);
            guideView.getTargetViewPosition();
            return guideView;
        }

        public void show() {
            this.create().show();
        }

        private static class GuideViewParams {
            View mTargetView;
            View mHintView;
            int mDirection;
            int mHintViewSpace = 20;
            int mTransparentPadding;
            int mTransparentPaddingLeft;
            int mTransparentPaddingTop;
            int mTransparentPaddingRight;
            int mTransparentPaddingBottom;
            int mTransparentMargin;
            int mTransparentMarginLeft;
            int mTransparentMarginRight;
            int mTransparentMarginTop;
            int mTransparentMarginBottom;
            int mHintViewMargin;
            int mHintViewMarginLeft;
            int mHintViewMarginRight;
            int mHintViewMarginTop;
            int mHintViewMarginBottom;
            @ColorInt
            int maskLayerColor = -870507492;
            RelativeLayout.LayoutParams mHintLayoutParams;
            View.OnClickListener mClickListener;

            private GuideViewParams() {
            }
        }
    }
}

