/*
 * Decompiled with CFR 0.152.
 */
package cn.lemon.view;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.support.annotation.ColorInt;
import android.support.annotation.IdRes;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;

public class GuideView
extends RelativeLayout {
    private final String TAG = "GuideView";
    private boolean hasAddHintView = false;
    private boolean isShowing = false;
    private int mHintViewSpace = 0;
    private int mTransparentPadding;
    private int mTransparentPaddingLeft;
    private int mTransparentPaddingTop;
    private int mTransparentPaddingRight;
    private int mTransparentPaddingBottom;
    private int mTransparentMargin;
    private int mTransparentMarginLeft;
    private int mTransparentMarginRight;
    private int mTransparentMarginTop;
    private int mTransparentMarginBottom;
    private int mHintViewMargin;
    private int mHintViewMarginLeft;
    private int mHintViewMarginRight;
    private int mHintViewMarginTop;
    private int mHintViewMarginBottom;
    private int[] mTargetViewLocation = new int[2];
    private int mTargetViewWidth;
    private int mTargetViewHeight;
    private int mHintViewDirection;
    @ColorInt
    private int MASK_LAYER_COLOR = -652403684;
    private RelativeLayout.LayoutParams mHintLayoutParams;
    private Paint mBackgroundPaint;
    private Paint mTransparentPaint;
    private View mHintView;
    private View mTargetView;
    private FrameLayout mDecorView;

    public GuideView(Context context) {
        this(context, null);
    }

    public GuideView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GuideView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        Log.i((String)"GuideView", (String)" --- GuideView");
        this.mDecorView = (FrameLayout)((Activity)this.getContext()).getWindow().getDecorView();
        this.mBackgroundPaint = new Paint();
        this.mTransparentPaint = new Paint();
        this.mBackgroundPaint.setColor(this.MASK_LAYER_COLOR);
    }

    public void initParams(Builder.GuideViewParams params) {
        Log.i((String)"GuideView", (String)"initParams");
        this.mTargetView = params.mTargetView;
        this.mHintView = params.mHintView;
        this.mHintViewSpace = params.mHintViewSpace;
        this.mTransparentPadding = params.mTransparentPadding;
        this.mTransparentPaddingLeft = params.mTransparentPaddingLeft;
        this.mTransparentPaddingTop = params.mTransparentPaddingTop;
        this.mTransparentPaddingRight = params.mTransparentPaddingRight;
        this.mTransparentPaddingBottom = params.mTransparentPaddingBottom;
        this.mTransparentMargin = params.mTransparentMargin;
        this.mTransparentMarginLeft = params.mTransparentMarginLeft;
        this.mTransparentMarginRight = params.mTransparentMarginRight;
        this.mTransparentMarginTop = params.mTransparentMarginTop;
        this.mTransparentMarginBottom = params.mTransparentMarginBottom;
        this.mHintViewMargin = params.mHintViewMargin;
        this.mHintViewMarginLeft = params.mHintViewMarginLeft;
        this.mHintViewMarginRight = params.mHintViewMarginRight;
        this.mHintViewMarginTop = params.mHintViewMarginTop;
        this.mHintViewMarginBottom = params.mHintViewMarginBottom;
        this.mHintViewDirection = params.mDirection;
        this.MASK_LAYER_COLOR = params.MASK_LAYER_COLOR;
        this.mHintLayoutParams = params.mHintLayoutParams;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Log.i((String)"GuideView", (String)" --- onMeasure");
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        Log.i((String)"GuideView", (String)" --- onLayout");
        super.onLayout(changed, l, t, r, b);
    }

    protected void onDraw(Canvas canvas) {
        Log.i((String)"GuideView", (String)" --- onDraw");
        if (this.mTargetView == null) {
            return;
        }
        this.getTargetViewPosition();
        this.drawMaskLayer(canvas);
    }

    private void drawMaskLayer(Canvas canvas) {
        Log.i((String)"GuideView", (String)" --- drawMaskLayer");
        Bitmap bitmap = Bitmap.createBitmap((int)canvas.getWidth(), (int)canvas.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas mTemp = new Canvas(bitmap);
        mTemp.drawRect(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight(), this.mBackgroundPaint);
        PorterDuffXfermode mDrawMode = new PorterDuffXfermode(PorterDuff.Mode.SRC_OUT);
        this.mTransparentPaint.setXfermode((Xfermode)mDrawMode);
        this.mTransparentPaint.setAntiAlias(true);
        if (this.mTransparentPadding != 0) {
            this.mTransparentPaddingLeft = this.mTransparentPadding;
            this.mTransparentPaddingRight = this.mTransparentPadding;
            this.mTransparentPaddingTop = this.mTransparentPadding;
            this.mTransparentPaddingBottom = this.mTransparentPadding;
        }
        if (this.mTransparentMargin != 0) {
            this.mTransparentMarginLeft = this.mTransparentMargin;
            this.mTransparentMarginRight = this.mTransparentMargin;
            this.mTransparentMarginTop = this.mTransparentMargin;
            this.mTransparentMarginBottom = this.mTransparentMargin;
        }
        if (this.mHintViewMargin != 0) {
            this.mHintViewMarginLeft = this.mHintViewMargin;
            this.mHintViewMarginRight = this.mHintViewMargin;
            this.mHintViewMarginTop = this.mHintViewMargin;
            this.mHintViewMarginBottom = this.mHintViewMargin;
        }
        RectF rectF = new RectF((float)(this.mTargetViewLocation[0] - this.mTransparentPaddingLeft + this.mTransparentMarginLeft), (float)(this.mTargetViewLocation[1] - this.mTransparentPaddingTop + this.mTransparentMarginTop), (float)(this.mTargetViewLocation[0] + this.mTargetViewWidth + this.mTransparentPaddingRight - this.mTransparentMarginRight), (float)(this.mTargetViewLocation[1] + this.mTargetViewHeight + this.mTransparentPaddingBottom - this.mTransparentMarginBottom));
        mTemp.drawOval(rectF, this.mTransparentPaint);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, this.mBackgroundPaint);
    }

    private void addHintView() {
        if (this.hasAddHintView) {
            return;
        }
        Log.i((String)"GuideView", (String)" --- addHintView");
        if (this.mHintView != null) {
            int screenWidth = this.getWidth();
            int screenHeight = this.getHeight();
            RelativeLayout.LayoutParams layoutParams = this.mHintLayoutParams != null ? this.mHintLayoutParams : new RelativeLayout.LayoutParams(-2, -2);
            switch (this.mHintViewDirection) {
                case 10: {
                    this.setGravity(5);
                    layoutParams.setMargins(0, this.mTargetViewLocation[1], screenWidth - this.mTargetViewLocation[0] + this.mHintViewSpace + this.mHintViewMarginRight, 0);
                    break;
                }
                case 12: {
                    this.setGravity(53);
                    layoutParams.setMargins(0, this.mTargetViewLocation[1] + this.mTargetViewHeight + this.mHintViewSpace + this.mHintViewMarginTop, screenWidth - this.mTargetViewLocation[0] + this.mHintViewSpace + this.mHintViewMarginRight, 0);
                    break;
                }
                case 11: {
                    this.setGravity(85);
                    layoutParams.setMargins(0, 0, screenWidth - this.mTargetViewLocation[0] + this.mHintViewSpace + this.mHintViewMarginRight, screenHeight - this.mTargetViewLocation[1] + this.mHintViewSpace + this.mHintViewMarginBottom);
                    break;
                }
                case 13: {
                    this.setGravity(85);
                    layoutParams.setMargins(0, this.mTargetViewLocation[1], screenWidth - this.mTargetViewLocation[0] + this.mHintViewSpace + this.mHintViewMarginRight, screenHeight - this.mTargetViewLocation[1] - this.mTargetViewHeight);
                    break;
                }
                case 20: {
                    this.setGravity(3);
                    layoutParams.setMargins(this.mTargetViewLocation[0] + this.mTargetViewWidth + this.mHintViewSpace + this.mHintViewMarginLeft, this.mTargetViewLocation[1], 0, 0);
                    break;
                }
                case 21: {
                    this.setGravity(83);
                    layoutParams.setMargins(this.mTargetViewWidth + this.mTargetViewLocation[0] + this.mHintViewSpace + this.mHintViewMarginLeft, 0, 0, screenHeight - this.mTargetViewLocation[1] + this.mHintViewSpace + this.mHintViewMarginBottom);
                    break;
                }
                case 22: {
                    this.setGravity(51);
                    layoutParams.setMargins(this.mTargetViewLocation[0] + this.mTargetViewWidth + this.mHintViewSpace + this.mHintViewMarginLeft, this.mTargetViewLocation[1] + this.mTargetViewHeight + this.mHintViewSpace + this.mHintViewMarginTop, 0, 0);
                    break;
                }
                case 23: {
                    this.setGravity(83);
                    layoutParams.setMargins(this.mTargetViewLocation[0] + this.mTargetViewWidth + this.mHintViewSpace + this.mHintViewMarginLeft, this.mTargetViewLocation[1], 0, screenHeight - this.mTargetViewLocation[1] - this.mTargetViewHeight);
                    break;
                }
                case 30: {
                    this.setGravity(80);
                    layoutParams.setMargins(0, 0, 0, screenHeight - this.mTargetViewLocation[1] + this.mHintViewSpace + this.mHintViewMarginBottom);
                    break;
                }
                case 31: {
                    this.setGravity(83);
                    layoutParams.setMargins(this.mTargetViewLocation[0] + this.mHintViewMarginLeft, 0, 0, screenHeight - this.mTargetViewLocation[1] + this.mHintViewSpace + this.mHintViewMarginBottom);
                    break;
                }
                case 32: {
                    this.setGravity(85);
                    layoutParams.setMargins(0, 0, screenWidth - this.mTargetViewLocation[0] - this.mTargetViewWidth + this.mHintViewMarginRight, screenHeight - this.mTargetViewLocation[1] + this.mHintViewSpace + this.mHintViewMarginBottom);
                    break;
                }
                case 40: {
                    this.setGravity(48);
                    layoutParams.setMargins(0, this.mTargetViewLocation[1] + this.mTargetViewHeight + this.mHintViewMarginTop, 0, 0);
                    break;
                }
                case 41: {
                    this.setGravity(48);
                    layoutParams.setMargins(this.mTargetViewLocation[0] + this.mHintViewMarginLeft, this.mTargetViewLocation[1] + this.mTargetViewHeight + this.mHintViewSpace + this.mHintViewMarginTop, 0, 0);
                    break;
                }
                case 42: {
                    this.setGravity(48);
                    layoutParams.setMargins(0, this.mTargetViewLocation[1] + this.mTargetViewHeight + this.mHintViewSpace + this.mHintViewMarginTop, screenWidth - this.mTargetViewLocation[0] - this.mTargetViewWidth + this.mHintViewMarginRight, 0);
                }
            }
            if (this.mHintView.getParent() != null) {
                this.mHintView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                Log.i((String)"GuideView", (String)"hintView \u6709\u7238\u7238\u5566\u3002\u3002\u3002");
            } else {
                this.addView(this.mHintView, (ViewGroup.LayoutParams)layoutParams);
                this.hasAddHintView = true;
            }
        }
    }

    public void hide() {
        Log.i((String)"GuideView", (String)"hide");
        this.removeAllViews();
        this.mDecorView.removeView((View)this);
    }

    public void show() {
        Log.i((String)"GuideView", (String)"show : add GuideView into DecorView");
        if (this.isShowing()) {
            return;
        }
        this.setBackgroundColor(0);
        this.mDecorView.addView((View)this);
        this.isShowing = true;
    }

    private boolean isShowing() {
        if (this.mTargetView == null) {
            Log.i((String)"GuideView", (String)"mTargetView == null");
            return true;
        }
        return this.isShowing;
    }

    public void getTargetViewPosition() {
        if (this.mTargetView == null) {
            Log.i((String)"GuideView", (String)"mTargetView == null");
            return;
        }
        if (this.mTargetView.getWidth() > 0 && this.mTargetView.getHeight() > 0) {
            this.mTargetView.getLocationInWindow(this.mTargetViewLocation);
            if (this.mTargetViewWidth == 0 || this.mTargetViewHeight == 0) {
                this.mTargetViewWidth = this.mTargetView.getWidth();
                this.mTargetViewHeight = this.mTargetView.getHeight();
            }
            Log.i((String)"GuideView", (String)("targetView.width : " + this.mTargetView.getWidth() + " location x : " + this.mTargetViewLocation[0]));
            Log.i((String)"GuideView", (String)("targetView.height : " + this.mTargetView.getHeight() + " location y : " + this.mTargetViewLocation[1]));
            this.addHintView();
        } else {
            Log.i((String)"GuideView", (String)"targetView is not measured,please user view.post(Runnable run) initialize GuideView");
        }
    }

    public static class Builder {
        private GuideViewParams mParams = new GuideViewParams();
        private Context mContext;

        public Builder(Context ctx) {
            this.mContext = ctx;
        }

        public Builder setTargetView(View targetView) {
            this.mParams.mTargetView = targetView;
            return this;
        }

        public Builder setTargetView(@IdRes int resId) {
            this.mParams.mTargetView = ((Activity)this.mContext).findViewById(resId);
            return this;
        }

        public Builder setHintView(View hintView) {
            this.mParams.mHintView = hintView;
            return this;
        }

        public Builder setHintViewDirection(int direction) {
            this.mParams.mDirection = direction;
            return this;
        }

        public Builder setTransparentOvalPadding(int px) {
            this.mParams.mTransparentPadding = px;
            return this;
        }

        public Builder setTransparentOvalPaddingLeft(int px) {
            this.mParams.mTransparentPaddingLeft = px;
            return this;
        }

        public Builder setTransparentOvalPaddingRight(int px) {
            this.mParams.mTransparentPaddingRight = px;
            return this;
        }

        public Builder setTransparentOvalPaddingTop(int px) {
            this.mParams.mTransparentPaddingTop = px;
            return this;
        }

        public Builder setTransparentOvalPaddingBottom(int px) {
            this.mParams.mTransparentPaddingBottom = px;
            return this;
        }

        public Builder setTransparentMargin(int px) {
            this.mParams.mTransparentMargin = px;
            return this;
        }

        public Builder setTransparentMarginLeft(int mTransparentMarginLeft) {
            this.mParams.mTransparentMarginLeft = mTransparentMarginLeft;
            return this;
        }

        public Builder setTransparentMarginRight(int mTransparentMarginRight) {
            this.mParams.mTransparentMarginRight = mTransparentMarginRight;
            return this;
        }

        public Builder setTransparentMarginTop(int mTransparentMarginTop) {
            this.mParams.mTransparentMarginTop = mTransparentMarginTop;
            return this;
        }

        public Builder setTransparentMarginBottom(int mTransparentMarginBottom) {
            this.mParams.mTransparentMarginBottom = mTransparentMarginBottom;
            return this;
        }

        public Builder setHintViewMargin(int px) {
            this.mParams.mHintViewMargin = px;
            return this;
        }

        public Builder setHintViewMarginLeft(int px) {
            this.mParams.mHintViewMarginLeft = px;
            return this;
        }

        public Builder setHintViewMarginRight(int px) {
            this.mParams.mHintViewMarginRight = px;
            return this;
        }

        public Builder setHintViewMarginTop(int px) {
            this.mParams.mHintViewMarginTop = px;
            return this;
        }

        public Builder setHintViewMarginBottom(int px) {
            this.mParams.mHintViewMarginBottom = px;
            return this;
        }

        public Builder setHintViewSpace(int px) {
            this.mParams.mHintViewSpace = px;
            return this;
        }

        public Builder setBackgroundColor(@ColorInt int color) {
            this.mParams.MASK_LAYER_COLOR = color;
            return this;
        }

        public Builder setHintLayoutParams(RelativeLayout.LayoutParams mHintLayoutParams) {
            this.mParams.mHintLayoutParams = mHintLayoutParams;
            return this;
        }

        public Builder setOnClickListener(View.OnClickListener listener) {
            this.mParams.mClickListener = listener;
            return this;
        }

        public GuideView create() {
            if (this.mParams.mTargetView == null) {
                throw new RuntimeException("please set a targetView");
            }
            GuideView guideView = new GuideView(this.mContext);
            guideView.initParams(this.mParams);
            guideView.setOnClickListener(this.mParams.mClickListener);
            return guideView;
        }

        public void show() {
            this.create().show();
        }

        private static class GuideViewParams {
            View mTargetView;
            View mHintView;
            int mDirection;
            int mHintViewSpace = 20;
            int mTransparentPadding;
            int mTransparentPaddingLeft;
            int mTransparentPaddingTop;
            int mTransparentPaddingRight;
            int mTransparentPaddingBottom;
            int mTransparentMargin;
            int mTransparentMarginLeft;
            int mTransparentMarginRight;
            int mTransparentMarginTop;
            int mTransparentMarginBottom;
            int mHintViewMargin;
            int mHintViewMarginLeft;
            int mHintViewMarginRight;
            int mHintViewMarginTop;
            int mHintViewMarginBottom;
            @ColorInt
            int MASK_LAYER_COLOR = -870507492;
            RelativeLayout.LayoutParams mHintLayoutParams;
            View.OnClickListener mClickListener;

            private GuideViewParams() {
            }
        }
    }
}

