/*
 * Decompiled with CFR 0.152.
 */
package cn.lemon.view;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.IdRes;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;

public class GuideView
extends RelativeLayout
implements ViewTreeObserver.OnGlobalLayoutListener {
    private final String TAG = "GuideView";
    private boolean isMeasure = false;
    private boolean isShowOnce = false;
    private int mHintViewSpace = 0;
    private int mTransparentPadding;
    private int mTransparentPaddingLeft;
    private int mTransparentPaddingTop;
    private int mTransparentPaddingRight;
    private int mTransparentPaddingBottom;
    private int mTransparentMarginLeft;
    private int mTransparentMarginRight;
    private int mTransparentMarginTop;
    private int mTransparentMarginBottom;
    private int[] mTargetViewLocation = new int[2];
    private int mTargetViewWidth;
    private int mTargetViewHeight;
    private int mHintViewDirection;
    @ColorInt
    private int MASK_LAYER_COLOR = -870507492;
    private RelativeLayout.LayoutParams mHintLayoutParams;
    private Paint mBackgroundPaint;
    private Paint mTransparentPaint;
    private View mHintView;
    private Context mContext;
    private View mTargetView;
    private FrameLayout mDecorView;

    public GuideView(Context context) {
        this(context, null);
    }

    public GuideView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GuideView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        Log.i((String)"GuideView", (String)" --- GuideView");
        this.mContext = context;
        this.mDecorView = (FrameLayout)((Activity)this.getContext()).getWindow().getDecorView();
        this.mBackgroundPaint = new Paint();
        this.mTransparentPaint = new Paint();
        this.mBackgroundPaint.setColor(this.MASK_LAYER_COLOR);
    }

    private void setMaskBackgroundColor(@ColorInt int color) {
        this.mBackgroundPaint.setColor(color);
    }

    private void setTransparentPadding(int padding) {
        this.mTransparentPadding = padding;
    }

    private void setTransparentPaddingLeft(int mTransparentPaddingLeft) {
        this.mTransparentPaddingLeft = mTransparentPaddingLeft;
    }

    private void setTransparentPaddingTop(int mTransparentPaddingTop) {
        this.mTransparentPaddingTop = mTransparentPaddingTop;
    }

    private void setTransparentPaddingRight(int mTransparentPaddingRight) {
        this.mTransparentPaddingRight = mTransparentPaddingRight;
    }

    private void setTransparentPaddingBottom(int mTransparentPaddingBottom) {
        this.mTransparentPaddingBottom = mTransparentPaddingBottom;
    }

    public void setTransparentMarginLeft(int mTransparentMarginLeft) {
        this.mTransparentMarginLeft = mTransparentMarginLeft;
    }

    public void setTransparentMarginRight(int mTransparentMarginRight) {
        this.mTransparentMarginRight = mTransparentMarginRight;
    }

    public void setTransparentMarginTop(int mTransparentMarginTop) {
        this.mTransparentMarginTop = mTransparentMarginTop;
    }

    public void setTransparentMarginBottom(int mTransparentMarginBottom) {
        this.mTransparentMarginBottom = mTransparentMarginBottom;
    }

    public void setHintLayoutParams(RelativeLayout.LayoutParams mHintLayoutParams) {
        this.mHintLayoutParams = mHintLayoutParams;
    }

    private void setHintViewSpace(int mHintViewSpace) {
        this.mHintViewSpace = mHintViewSpace;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        Log.i((String)"GuideView", (String)" --- onMeasure");
    }

    protected void onDraw(Canvas canvas) {
        Log.i((String)"GuideView", (String)" --- onDraw");
        if (!this.isMeasure || this.mTargetView == null) {
            return;
        }
        this.drawMaskLayer(canvas);
    }

    private void drawMaskLayer(Canvas canvas) {
        Log.i((String)"GuideView", (String)" --- drawMaskLayer");
        Bitmap bitmap = Bitmap.createBitmap((int)canvas.getWidth(), (int)canvas.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas mTemp = new Canvas(bitmap);
        mTemp.drawRect(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight(), this.mBackgroundPaint);
        PorterDuffXfermode mDrawMode = new PorterDuffXfermode(PorterDuff.Mode.SRC_OUT);
        this.mTransparentPaint.setXfermode((Xfermode)mDrawMode);
        this.mTransparentPaint.setAntiAlias(true);
        if (this.mTransparentPadding != 0) {
            this.mTransparentPaddingLeft = this.mTransparentPadding;
            this.mTransparentPaddingRight = this.mTransparentPadding;
            this.mTransparentPaddingTop = this.mTransparentPadding;
            this.mTransparentPaddingBottom = this.mTransparentPadding;
        }
        RectF rectF = new RectF((float)(this.mTargetViewLocation[0] - this.mTransparentPaddingLeft + this.mTransparentMarginLeft), (float)(this.mTargetViewLocation[1] - this.mTransparentPaddingTop + this.mTransparentMarginTop), (float)(this.mTargetViewLocation[0] + this.mTargetViewWidth + this.mTransparentPaddingRight - this.mTransparentMarginRight), (float)(this.mTargetViewLocation[1] + this.mTargetViewHeight + this.mTransparentPaddingBottom - this.mTransparentMarginBottom));
        mTemp.drawOval(rectF, this.mTransparentPaint);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, this.mBackgroundPaint);
    }

    private void addHintView() {
        Log.i((String)"GuideView", (String)" --- addHintView");
        if (this.mHintView != null) {
            int screenWidth = this.getWidth();
            int screenHeight = this.getHeight();
            RelativeLayout.LayoutParams layoutParams = this.mHintLayoutParams != null ? this.mHintLayoutParams : new RelativeLayout.LayoutParams(-2, -2);
            switch (this.mHintViewDirection) {
                case 0: {
                    break;
                }
                case 1: {
                    this.setGravity(5);
                    layoutParams.setMargins(0, this.mTargetViewLocation[1], screenWidth - this.mTargetViewLocation[0] + this.mHintViewSpace, 0);
                    break;
                }
                case 5: {
                    this.setGravity(3);
                    layoutParams.setMargins(this.mTargetViewLocation[0] + this.mTargetViewWidth + this.mHintViewSpace, this.mTargetViewLocation[1], 0, 0);
                    break;
                }
                case 3: {
                    this.setGravity(80);
                    layoutParams.setMargins(0, this.mTargetViewLocation[0], 0, screenHeight - this.mTargetViewLocation[1] + this.mHintViewSpace);
                    break;
                }
                case 4: {
                    this.setGravity(48);
                    layoutParams.setMargins(this.mTargetViewLocation[0], this.mTargetViewLocation[1] + this.mTargetViewHeight + this.mHintViewSpace, 0, 0);
                    break;
                }
                case 9: {
                    this.setGravity(48);
                    layoutParams.setMargins(0, this.mTargetViewLocation[1] + this.mTargetViewHeight + this.mHintViewSpace, screenWidth - this.mTargetViewLocation[0] - this.mTargetViewWidth, 0);
                }
                case 2: {
                    this.setGravity(53);
                    layoutParams.setMargins(0, this.mTargetViewLocation[1] + this.mTargetViewHeight + this.mHintViewSpace, screenWidth - this.mTargetViewLocation[0] + this.mHintViewSpace, 0);
                    break;
                }
                case 6: {
                    this.setGravity(51);
                    layoutParams.setMargins(this.mTargetViewLocation[0] + this.mTargetViewWidth + this.mHintViewSpace, this.mTargetViewLocation[1] + this.mTargetViewHeight + this.mHintViewSpace, 0, 0);
                    break;
                }
                case 7: {
                    this.setGravity(85);
                    layoutParams.setMargins(0, 0, screenWidth - this.mTargetViewLocation[0] + this.mHintViewSpace, screenHeight - this.mTargetViewLocation[1] + this.mHintViewSpace);
                    break;
                }
                case 8: {
                    this.setGravity(83);
                    layoutParams.setMargins(this.mTargetViewWidth + this.mTargetViewLocation[0] + this.mHintViewSpace, 0, 0, screenHeight - this.mTargetViewLocation[1] + this.mHintViewSpace);
                }
            }
            if (this.mHintView.getParent() != null) {
                this.mHintView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                Log.i((String)"GuideView", (String)"hintView \u6709\u7238\u7238\u5566\u3002\u3002\u3002");
            } else {
                this.addView(this.mHintView, (ViewGroup.LayoutParams)layoutParams);
            }
        }
    }

    public void hide() {
        Log.i((String)"GuideView", (String)"hide");
        if (this.isShowOnce && this.mTargetView != null) {
            this.getContext().getSharedPreferences("GuideView", 0).edit().putBoolean("GuideView" + this.mTargetView.getId(), true);
            if (Build.VERSION.SDK_INT >= 16) {
                this.mTargetView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        this.removeAllViews();
        this.mDecorView.removeView((View)this);
    }

    public void show() {
        Log.i((String)"GuideView", (String)"show");
        if (this.hasShow()) {
            return;
        }
        this.mTargetView.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        this.setBackgroundColor(0);
        this.mDecorView.addView((View)this);
    }

    private void showOnce(boolean isShowOnce) {
        this.isShowOnce = isShowOnce;
    }

    private boolean hasShow() {
        if (this.mTargetView == null) {
            Log.i((String)"GuideView", (String)"mTargetView == null");
            return true;
        }
        return this.getContext().getSharedPreferences("GuideView", 0).getBoolean("GuideView" + this.mTargetView.getId(), false);
    }

    private void setTargetView(View targetView) {
        this.mTargetView = targetView;
    }

    private void setTargetView(@IdRes int resId) {
        this.setTargetView(((Activity)this.getContext()).findViewById(resId));
    }

    private void setTargetView(@IdRes int resId, View view) {
        this.setTargetView(view.findViewById(resId));
    }

    private void setHintView(View hintView) {
        this.mHintView = hintView;
    }

    private void setHintViewDirection(int direction) {
        this.mHintViewDirection = direction;
    }

    public void onGlobalLayout() {
        Log.i((String)"GuideView", (String)" --- onGlobalLayout");
        if (this.mTargetView == null) {
            Log.i((String)"GuideView", (String)"mTargetView == null");
            return;
        }
        if (this.isMeasure) {
            return;
        }
        if (this.mTargetView.getWidth() > 0 && this.mTargetView.getHeight() > 0) {
            this.isMeasure = true;
            if (this.mTargetViewWidth == 0 || this.mTargetViewHeight == 0) {
                this.mTargetViewWidth = this.mTargetView.getWidth();
                this.mTargetViewHeight = this.mTargetView.getHeight();
                this.mTargetView.getLocationInWindow(this.mTargetViewLocation);
            }
            this.addHintView();
        } else {
            Log.i((String)"GuideView", (String)"targetView \u4e0d\u80fd\u88ab\u6d4b\u91cf\u3002\u3002\u3002\u3002\u3002");
        }
    }

    public static class Builder {
        private GuideView mGuideView;

        public Builder(Context ctx) {
            this.mGuideView = new GuideView(ctx);
        }

        public Builder setTargetView(View targetView) {
            this.mGuideView.setTargetView(targetView);
            return this;
        }

        public Builder setTargetView(@IdRes int resId) {
            this.mGuideView.setTargetView(resId);
            return this;
        }

        public Builder showOnce(boolean isShowOnce) {
            this.mGuideView.showOnce(isShowOnce);
            return this;
        }

        public Builder setHintView(View hintView) {
            this.mGuideView.setHintView(hintView);
            return this;
        }

        public Builder setHintViewDirection(int direction) {
            this.mGuideView.setHintViewDirection(direction);
            return this;
        }

        public Builder setTransparentOvalPadding(int px) {
            this.mGuideView.setTransparentPadding(px);
            return this;
        }

        public Builder setTransparentOvalPaddingLeft(int px) {
            this.mGuideView.setTransparentPaddingLeft(px);
            return this;
        }

        public Builder setTransparentOvalPaddingRight(int px) {
            this.mGuideView.setTransparentPaddingRight(px);
            return this;
        }

        public Builder setTransparentOvalPaddingTop(int px) {
            this.mGuideView.setTransparentPaddingTop(px);
            return this;
        }

        public Builder setTransparentOvalPaddingBottom(int px) {
            this.mGuideView.setTransparentPaddingBottom(px);
            return this;
        }

        public Builder setTransparentMarginLeft(int mTransparentMarginLeft) {
            this.mGuideView.setTransparentMarginLeft(mTransparentMarginLeft);
            return this;
        }

        public Builder setTransparentMarginRight(int mTransparentMarginRight) {
            this.mGuideView.setTransparentMarginRight(mTransparentMarginRight);
            return this;
        }

        public Builder setTransparentMarginTop(int mTransparentMarginTop) {
            this.mGuideView.setTransparentMarginTop(mTransparentMarginTop);
            return this;
        }

        public Builder setTransparentMarginBottom(int mTransparentMarginBottom) {
            this.mGuideView.setTransparentMarginBottom(mTransparentMarginBottom);
            return this;
        }

        public Builder setHintViewSpace(int px) {
            this.mGuideView.setHintViewSpace(px);
            return this;
        }

        public Builder setBackgroundColor(@ColorInt int color) {
            this.mGuideView.setMaskBackgroundColor(color);
            return this;
        }

        public Builder setHintLayoutParams(RelativeLayout.LayoutParams mHintLayoutParams) {
            this.mGuideView.setHintLayoutParams(mHintLayoutParams);
            return this;
        }

        public Builder setOnClickListener(View.OnClickListener listener) {
            this.mGuideView.setOnClickListener(listener);
            return this;
        }

        public GuideView create() {
            Log.i((String)"GuideView", (String)"Builder.create()");
            return this.mGuideView;
        }
    }
}

