/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.widget.repeater;

import android.view.View;
import cc.livvy.framework.widget.repeater.DataAdapter;
import cc.livvy.framework.widget.repeater.DataCell;
import cc.livvy.framework.widget.repeater.DataCellSelector;
import java.lang.reflect.Constructor;

public final class DataCellOrganizer {
    private DataAdapter mAdapter = null;
    private Class<?> mCellClass = null;
    private DataCellSelector mCellSelector = null;
    private Object mCellClassConstructorParameter = null;

    public DataCellOrganizer(DataAdapter adapter, Class<?> cellClass) {
        this.mAdapter = adapter;
        this.mCellClass = cellClass;
        this.mCellSelector = null;
        this.mCellClassConstructorParameter = null;
    }

    public DataCellOrganizer(DataAdapter adapter, DataCellSelector cellClassSelector) {
        this.mAdapter = adapter;
        this.mCellClass = null;
        this.mCellSelector = cellClassSelector;
        this.mCellClassConstructorParameter = null;
    }

    public final void setCellClass(Class<?> cls, Object cellClassConstructorParameter) {
        if (null != cls && DataCell.class.isAssignableFrom(cls)) {
            Class<?> oldCls = this.mCellClass;
            this.mCellClass = cls;
            this.mCellSelector = null;
            this.mCellClassConstructorParameter = cellClassConstructorParameter;
            if (oldCls != cls) {
                this.mAdapter.getDataView().setDataAdapter(this.mAdapter);
            }
        }
    }

    public final void setCellSelector(DataCellSelector selector, Object cellClassConstructorParameter) {
        DataCellSelector oldSelector = this.mCellSelector;
        this.mCellSelector = selector;
        this.mCellClassConstructorParameter = cellClassConstructorParameter;
        if (oldSelector != selector) {
            this.mAdapter.getDataView().setDataAdapter(this.mAdapter);
        }
    }

    public final void setCellClassConstructorParameter(Object cellClassConstructorParameter) {
        this.mCellClassConstructorParameter = cellClassConstructorParameter;
    }

    public final int getCellTypeCount() {
        if (null == this.mCellSelector) {
            return 1;
        }
        return this.mCellSelector.getCellTypeCount();
    }

    public final int getCellType(int position) {
        if (null == this.mCellSelector) {
            return 0;
        }
        return this.mCellSelector.getCellType(this.mAdapter, position);
    }

    public final Class<?> getCellClass(int position) {
        if (null == this.mCellSelector) {
            return this.mCellClass;
        }
        return this.mCellSelector.getCellClass(this.mAdapter, position);
    }

    public final View getCellView(View cellCachedView, int position) {
        Object tag;
        if (null != cellCachedView && (tag = cellCachedView.getTag()) instanceof DataCell) {
            DataCell cell = (DataCell)tag;
            cell.updateCellData(position);
            cell.bindData();
            return cell.getCellView();
        }
        DataCell cell = this.createCell(position);
        if (null == cell) {
            return null;
        }
        return cell.getCellView();
    }

    private DataCell createCell(int position) {
        Class<?> cellClass = this.getCellClass(position);
        DataCell cell = this.createCellFromClass(cellClass);
        if (null == cell) {
            return null;
        }
        cell.initAdapterAndCellViewForOnce(this.mAdapter, position);
        return cell;
    }

    private DataCell createCellFromClass(Class<?> cls) {
        block20: {
            if (!DataCell.class.isAssignableFrom(cls)) {
                return null;
            }
            Constructor<?>[] cons = cls.getDeclaredConstructors();
            if (null == cons || cons.length < 1) {
                try {
                    return (DataCell)cls.newInstance();
                }
                catch (Throwable throwable) {
                    break block20;
                }
            }
            for (Constructor<?> con : cons) {
                Class<?>[] paramClasses = con.getParameterTypes();
                try {
                    if (!con.isAccessible()) {
                        con.setAccessible(true);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (paramClasses.length < 1) {
                    try {
                        return (DataCell)con.newInstance(new Object[0]);
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                }
                if (1 == paramClasses.length) {
                    Class<?> paramCls = paramClasses[0];
                    DataCell cell = this.newCellWithOneParam(con, paramCls, this.mCellClassConstructorParameter);
                    if (null == cell) {
                        cell = this.newCellWithOneParam(con, paramCls, this.mAdapter.getContext());
                    }
                    if (null == cell) {
                        cell = this.newCellWithOneParam(con, paramCls, this.mCellSelector);
                    }
                    if (null == cell) {
                        cell = this.newCellWithOneParam(con, paramCls, this.mAdapter.getDataView());
                    }
                    if (null == cell) {
                        cell = this.newCellWithOneParam(con, paramCls, this.mAdapter);
                    }
                    if (null == cell) continue;
                    return cell;
                }
                if (2 != paramClasses.length || null == this.mCellClassConstructorParameter) continue;
                Class<?> paramCls1 = paramClasses[0];
                Class<?> paramCls2 = paramClasses[1];
                DataCell cell = this.newCellWithTwoParam(con, paramCls1, paramCls2, this.mCellClassConstructorParameter);
                if (null == cell) {
                    cell = this.newCellWithTwoParam(con, paramCls1, paramCls2, this.mAdapter.getContext());
                }
                if (null == cell) {
                    cell = this.newCellWithTwoParam(con, paramCls1, paramCls2, this.mCellSelector);
                }
                if (null == cell) {
                    cell = this.newCellWithTwoParam(con, paramCls1, paramCls2, this.mAdapter.getDataView());
                }
                if (null == cell) {
                    cell = this.newCellWithTwoParam(con, paramCls1, paramCls2, this.mAdapter);
                }
                if (null == cell) continue;
                return cell;
            }
        }
        return null;
    }

    private DataCell newCellWithTwoParam(Constructor<?> con, Class<?> firstParamClass, Class<?> secondParamClass, Object paramObject) {
        if (null == this.mCellClassConstructorParameter) {
            return null;
        }
        if (null == paramObject || null == secondParamClass || null == con || null == firstParamClass) {
            return null;
        }
        if (firstParamClass.isAssignableFrom(paramObject.getClass()) && secondParamClass.isAssignableFrom(this.mCellClassConstructorParameter.getClass())) {
            try {
                return (DataCell)con.newInstance(paramObject, this.mCellClassConstructorParameter);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private DataCell newCellWithOneParam(Constructor<?> con, Class<?> firstParamClass, Object paramObject) {
        if (null == paramObject || null == con || null == firstParamClass) {
            return null;
        }
        if (firstParamClass.isAssignableFrom(paramObject.getClass())) {
            try {
                return (DataCell)con.newInstance(paramObject);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }
}

