/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.widget.loadingview.indicator;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import cc.livvy.framework.widget.loadingview.indicator.BaseIndicatorController;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.ValueAnimator;
import java.util.ArrayList;
import java.util.List;

public class BallTrianglePathIndicator
extends BaseIndicatorController {
    float[] translateX = new float[3];
    float[] translateY = new float[3];

    @Override
    public void draw(Canvas canvas, Paint paint) {
        paint.setStrokeWidth(3.0f);
        paint.setStyle(Paint.Style.STROKE);
        for (int i = 0; i < 3; ++i) {
            canvas.save();
            canvas.translate(this.translateX[i], this.translateY[i]);
            canvas.drawCircle(0.0f, 0.0f, (float)(this.getWidth() / 10), paint);
            canvas.restore();
        }
    }

    @Override
    public List<Animator> createAnimation() {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        float startX = this.getWidth() / 5;
        float startY = this.getWidth() / 5;
        for (int i = 0; i < 3; ++i) {
            final int index = i;
            ValueAnimator translateXAnim = ValueAnimator.ofFloat((float[])new float[]{this.getWidth() / 2, (float)this.getWidth() - startX, startX, this.getWidth() / 2});
            if (i == 1) {
                translateXAnim = ValueAnimator.ofFloat((float[])new float[]{(float)this.getWidth() - startX, startX, this.getWidth() / 2, (float)this.getWidth() - startX});
            } else if (i == 2) {
                translateXAnim = ValueAnimator.ofFloat((float[])new float[]{startX, this.getWidth() / 2, (float)this.getWidth() - startX, startX});
            }
            ValueAnimator translateYAnim = ValueAnimator.ofFloat((float[])new float[]{startY, (float)this.getHeight() - startY, (float)this.getHeight() - startY, startY});
            if (i == 1) {
                translateYAnim = ValueAnimator.ofFloat((float[])new float[]{(float)this.getHeight() - startY, (float)this.getHeight() - startY, startY, (float)this.getHeight() - startY});
            } else if (i == 2) {
                translateYAnim = ValueAnimator.ofFloat((float[])new float[]{(float)this.getHeight() - startY, startY, (float)this.getHeight() - startY, (float)this.getHeight() - startY});
            }
            translateXAnim.setDuration(2000L);
            translateXAnim.setInterpolator((Interpolator)new LinearInterpolator());
            translateXAnim.setRepeatCount(-1);
            translateXAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    BallTrianglePathIndicator.this.translateX[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    BallTrianglePathIndicator.this.postInvalidate();
                }
            });
            translateXAnim.start();
            translateYAnim.setDuration(2000L);
            translateYAnim.setInterpolator((Interpolator)new LinearInterpolator());
            translateYAnim.setRepeatCount(-1);
            translateYAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    BallTrianglePathIndicator.this.translateY[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    BallTrianglePathIndicator.this.postInvalidate();
                }
            });
            translateYAnim.start();
            animators.add((Animator)translateXAnim);
            animators.add((Animator)translateYAnim);
        }
        return animators;
    }
}

