/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.widget.loadingview.indicator;

import android.graphics.Canvas;
import android.graphics.Paint;
import cc.livvy.framework.widget.loadingview.indicator.BaseIndicatorController;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.ValueAnimator;
import java.util.ArrayList;
import java.util.List;

public class BallPulseIndicator
extends BaseIndicatorController {
    public static final float SCALE = 1.0f;
    private float[] scaleFloats = new float[]{1.0f, 1.0f, 1.0f};

    @Override
    public void draw(Canvas canvas, Paint paint) {
        float circleSpacing = 4.0f;
        float radius = ((float)Math.min(this.getWidth(), this.getHeight()) - circleSpacing * 2.0f) / 6.0f;
        float x = (float)(this.getWidth() / 2) - (radius * 2.0f + circleSpacing);
        float y = this.getHeight() / 2;
        for (int i = 0; i < 3; ++i) {
            canvas.save();
            float translateX = x + radius * 2.0f * (float)i + circleSpacing * (float)i;
            canvas.translate(translateX, y);
            canvas.scale(this.scaleFloats[i], this.scaleFloats[i]);
            canvas.drawCircle(0.0f, 0.0f, radius, paint);
            canvas.restore();
        }
    }

    @Override
    public List<Animator> createAnimation() {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        int[] delays = new int[]{120, 240, 360};
        for (int i = 0; i < 3; ++i) {
            final int index = i;
            ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.3f, 1.0f});
            scaleAnim.setDuration(750L);
            scaleAnim.setRepeatCount(-1);
            scaleAnim.setStartDelay((long)delays[i]);
            scaleAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    ((BallPulseIndicator)BallPulseIndicator.this).scaleFloats[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    BallPulseIndicator.this.postInvalidate();
                }
            });
            scaleAnim.start();
            animators.add((Animator)scaleAnim);
        }
        return animators;
    }
}

