/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.widget.loadingview.indicator;

import android.graphics.Canvas;
import android.graphics.Paint;
import cc.livvy.framework.widget.loadingview.indicator.BaseIndicatorController;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.ValueAnimator;
import java.util.ArrayList;
import java.util.List;

public class BallBeatIndicator
extends BaseIndicatorController {
    public static final float SCALE = 1.0f;
    public static final int ALPHA = 255;
    private float[] scaleFloats = new float[]{1.0f, 1.0f, 1.0f};
    int[] alphas = new int[]{255, 255, 255};

    @Override
    public void draw(Canvas canvas, Paint paint) {
        float circleSpacing = 4.0f;
        float radius = ((float)this.getWidth() - circleSpacing * 2.0f) / 6.0f;
        float x = (float)(this.getWidth() / 2) - (radius * 2.0f + circleSpacing);
        float y = this.getHeight() / 2;
        for (int i = 0; i < 3; ++i) {
            canvas.save();
            float translateX = x + radius * 2.0f * (float)i + circleSpacing * (float)i;
            canvas.translate(translateX, y);
            canvas.scale(this.scaleFloats[i], this.scaleFloats[i]);
            paint.setAlpha(this.alphas[i]);
            canvas.drawCircle(0.0f, 0.0f, radius, paint);
            canvas.restore();
        }
    }

    @Override
    public List<Animator> createAnimation() {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        int[] delays = new int[]{350, 0, 350};
        for (int i = 0; i < 3; ++i) {
            final int index = i;
            ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.75f, 1.0f});
            scaleAnim.setDuration(700L);
            scaleAnim.setRepeatCount(-1);
            scaleAnim.setStartDelay((long)delays[i]);
            scaleAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    ((BallBeatIndicator)BallBeatIndicator.this).scaleFloats[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    BallBeatIndicator.this.postInvalidate();
                }
            });
            scaleAnim.start();
            ValueAnimator alphaAnim = ValueAnimator.ofInt((int[])new int[]{255, 51, 255});
            alphaAnim.setDuration(700L);
            alphaAnim.setRepeatCount(-1);
            alphaAnim.setStartDelay((long)delays[i]);
            alphaAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    BallBeatIndicator.this.alphas[index] = (Integer)animation.getAnimatedValue();
                    BallBeatIndicator.this.postInvalidate();
                }
            });
            alphaAnim.start();
            animators.add((Animator)scaleAnim);
            animators.add((Animator)alphaAnim);
        }
        return animators;
    }
}

