/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.widget.cycleview.adapter;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import cc.livvy.fragment.R;
import cc.livvy.framework.widget.cycleview.adapter.CrystalViewHolderCreator;
import java.util.List;

public class CrystalPageAdapter<T>
extends PagerAdapter {
    protected List<T> mDatas;
    protected CrystalViewHolderCreator holderCreator;
    private SparseArray<View> mViewList = new SparseArray();
    private View.OnClickListener onItemClickListener;
    private boolean canLoop = true;

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
    }

    public int toRealPosition(int position) {
        int realCount = this.getRealCount();
        if (realCount == 0) {
            return 0;
        }
        int realPosition = position % realCount;
        return realPosition;
    }

    public int getCount() {
        return this.canLoop ? Integer.MAX_VALUE : this.getRealCount();
    }

    public int getRealCount() {
        return this.mDatas == null ? 0 : this.mDatas.size();
    }

    public Object instantiateItem(ViewGroup container, int position) {
        int realPosition = this.toRealPosition(position);
        View view = this.getView(realPosition, null, container);
        if (this.onItemClickListener != null) {
            view.setOnClickListener(this.onItemClickListener);
        }
        container.addView(view);
        this.mViewList.put(position, (Object)view);
        return view;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        if (this.mViewList.size() > 3) {
            container.removeView((View)this.mViewList.get(position));
            this.mViewList.remove(position);
        }
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public void setCanLoop(boolean canLoop) {
        this.canLoop = canLoop;
    }

    public CrystalPageAdapter(CrystalViewHolderCreator holderCreator, List<T> datas) {
        this.holderCreator = holderCreator;
        this.mDatas = datas;
    }

    public View getView(int position, View view, ViewGroup container) {
        Holder holder = null;
        if (view == null) {
            holder = (Holder)this.holderCreator.createHolder();
            view = holder.createView(container.getContext());
            view.setTag(R.id.cb_item_tag, (Object)holder);
        } else {
            holder = (Holder)view.getTag(R.id.cb_item_tag);
        }
        if (this.mDatas != null && !this.mDatas.isEmpty()) {
            holder.UpdateUI(container.getContext(), position, this.mDatas.get(position));
        }
        return view;
    }

    public void setOnItemClickListener(View.OnClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public static interface Holder<T> {
        public View createView(Context var1);

        public void UpdateUI(Context var1, int var2, T var3);
    }

    static class ToDestroy {
        View view;

        public ToDestroy(View view) {
            this.view = view;
        }
    }
}

