/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.http.callback;

import cc.livvy.framework.http.OkHttpUtils;
import cc.livvy.framework.http.callback.Callback;
import com.squareup.okhttp.Response;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class FileCallBack
extends Callback<File> {
    private String destFileDir;
    private String destFileName;

    @Override
    public abstract void inProgress(float var1);

    public FileCallBack(String destFileDir, String destFileName) {
        this.destFileDir = destFileDir;
        this.destFileName = destFileName;
    }

    @Override
    public File parseNetworkResponse(Response response) throws IOException {
        return this.saveFile(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File saveFile(Response response) throws IOException {
        InputStream is = null;
        byte[] buf = new byte[2048];
        int len = 0;
        FileOutputStream fos = null;
        try {
            is = response.body().byteStream();
            final long total = response.body().contentLength();
            long sum = 0L;
            File dir = new File(this.destFileDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(dir, this.destFileName);
            fos = new FileOutputStream(file);
            while ((len = is.read(buf)) != -1) {
                fos.write(buf, 0, len);
                final long finalSum = sum += (long)len;
                OkHttpUtils.getInstance().getDelivery().post(new Runnable(){

                    @Override
                    public void run() {
                        FileCallBack.this.inProgress((float)finalSum * 1.0f / (float)total);
                    }
                });
            }
            fos.flush();
            File file2 = file;
            return file2;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

