/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.data.encrypt;

import cc.livvy.framework.data.encoding.HexBytes;
import cc.livvy.framework.data.encoding.IntBytes;
import java.nio.charset.Charset;

public class Xxtea {
    public static String hexEncrypt(byte[] data, String key) {
        if (null == data || data.length == 0) {
            return null;
        }
        try {
            int[] intData = IntBytes.toIntArray(data, true);
            int[] intKey = IntBytes.toIntArray(key.getBytes(Charset.forName("UTF-8")), false);
            int[] intResult = Xxtea.encrypt(intData, intKey);
            byte[] byteResult = IntBytes.toByteArray(intResult, false);
            return HexBytes.byte2hex(byteResult);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static byte[] hexDecrypt(String data, String key) {
        byte[] byteData = HexBytes.hexToBytes(data);
        if (null == byteData || byteData.length == 0) {
            return null;
        }
        try {
            int[] intData = IntBytes.toIntArray(byteData, false);
            int[] intKey = IntBytes.toIntArray(key.getBytes(Charset.forName("UTF-8")), false);
            int[] intResult = Xxtea.decrypt(intData, intKey);
            return IntBytes.toByteArray(intResult, true);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static String encrypt(String data, String key) {
        try {
            return new String(Xxtea.encrypt(data.getBytes(Charset.forName("UTF-8")), key.getBytes(Charset.forName("UTF-8"))));
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static String decrypt(String data, String key) {
        try {
            return new String(Xxtea.decrypt(data.getBytes(Charset.forName("UTF-8")), key.getBytes(Charset.forName("UTF-8"))));
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static byte[] encrypt(byte[] data, byte[] key) {
        if (null == data || data.length == 0) {
            return null;
        }
        try {
            int[] intData = IntBytes.toIntArray(data, true);
            int[] intKey = IntBytes.toIntArray(key, false);
            int[] intResult = Xxtea.encrypt(intData, intKey);
            return IntBytes.toByteArray(intResult, false);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static byte[] decrypt(byte[] data, byte[] key) {
        if (null == data || data.length == 0) {
            return null;
        }
        try {
            int[] intData = IntBytes.toIntArray(data, false);
            int[] intKey = IntBytes.toIntArray(key, false);
            int[] intResult = Xxtea.decrypt(intData, intKey);
            return IntBytes.toByteArray(intResult, true);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static int[] encrypt(int[] v, int[] k) {
        int n = v.length - 1;
        if (n < 1) {
            return v;
        }
        if (k.length < 4) {
            int[] key = new int[4];
            System.arraycopy(k, 0, key, 0, k.length);
            k = key;
        }
        int z = v[n];
        int delta = -1640531527;
        int sum = 0;
        int q = 6 + 52 / (n + 1);
        while (q-- > 0) {
            int y;
            int p;
            int e = (sum += delta) >>> 2 & 3;
            for (p = 0; p < n; ++p) {
                y = v[p + 1];
                int n2 = p;
                int n3 = v[n2] + ((z >>> 5 ^ y << 2) + (y >>> 3 ^ z << 4) ^ (sum ^ y) + (k[p & 3 ^ e] ^ z));
                v[n2] = n3;
                z = n3;
            }
            y = v[0];
            int n4 = n;
            int n5 = v[n4] + ((z >>> 5 ^ y << 2) + (y >>> 3 ^ z << 4) ^ (sum ^ y) + (k[p & 3 ^ e] ^ z));
            v[n4] = n5;
            z = n5;
        }
        return v;
    }

    private static int[] decrypt(int[] v, int[] k) {
        int n = v.length - 1;
        if (n < 1) {
            return v;
        }
        if (k.length < 4) {
            int[] key = new int[4];
            System.arraycopy(k, 0, key, 0, k.length);
            k = key;
        }
        int y = v[0];
        int delta = -1640531527;
        int q = 6 + 52 / (n + 1);
        for (int sum = q * delta; sum != 0; sum -= delta) {
            int p;
            int e = sum >>> 2 & 3;
            for (p = n; p > 0; --p) {
                int z = v[p - 1];
                int n2 = p;
                int n3 = v[n2] - ((z >>> 5 ^ y << 2) + (y >>> 3 ^ z << 4) ^ (sum ^ y) + (k[p & 3 ^ e] ^ z));
                v[n2] = n3;
                y = n3;
            }
            int z = v[n];
            y = v[0] = v[0] - ((z >>> 5 ^ y << 2) + (y >>> 3 ^ z << 4) ^ (sum ^ y) + (k[p & 3 ^ e] ^ z));
        }
        return v;
    }
}

