package cc.livvy.framework.manager;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

import cc.livvy.framework.base.BaseApp;


/**
 * Created by livvym on 16-1-29.
 *
 */
public class NetworkManager {

    /**
     * 检查当前网络是否可用
     */
    public static boolean isNetworkAvailable() {
        Context context = BaseApp.getAppContext();
        // 获取手机所有连接管理对象（包括对wi-fi,net等连接的管理）
        ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);

        if (connectivityManager == null) {
            return false;
        } else {
            // 获取NetworkInfo对象
            NetworkInfo[] networkInfo = connectivityManager.getAllNetworkInfo();

            if (networkInfo != null && networkInfo.length > 0) {
                for (int i = 0; i < networkInfo.length; i++) {
//                    System.out.println(i + "===状态===" + networkInfo[i].getState());
//                    System.out.println(i + "===类型===" + networkInfo[i].getTypeName());
                    // 判断当前网络状态是否为连接状态
                    if (networkInfo[i].getState() == NetworkInfo.State.CONNECTED) {
                        return true;
                    }
                }
            }
        }
        return false;
    }
}
