/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.widget.repeater;

import android.os.Message;
import android.view.View;
import cc.livvy.framework.data.model.DataItem;
import cc.livvy.framework.data.model.DataResult;
import cc.livvy.framework.util.handler.MessageHandler;
import cc.livvy.framework.widget.repeater.DataAdapter;
import cc.livvy.framework.widget.repeater.DataLoader;
import cc.livvy.framework.widget.repeater.DataView;
import cc.livvy.framework.widget.repeater.OnDataLoadListener;
import cc.livvy.framework.widget.repeater.OnDataRefreshedListener;

public class DataLoadControl {
    private DataAdapter mAdapter;
    private OnDataLoadListener mOnDataLoadListener = null;
    private OnDataRefreshedListener mDataRefreshedListener = null;
    private DataLoader mDataLoader = null;
    private final DataResult mDataList = new DataResult();
    private DataResult mNetLoadData = null;
    private volatile boolean mDataLoadProcessing = false;
    private volatile boolean mDataLoadNoError = true;
    private volatile boolean mDataLoadCalled = false;
    private volatile boolean mDataHasSetup = false;
    private Thread mDataLoadThread = null;
    private long mMainThreadID = Thread.currentThread().getId();
    private boolean mKeepDataWhenOnRefresh = true;
    private boolean mDataRefreshNow = false;
    private int mPageAt = 0;
    private int mPageSize = 10;
    private int mMaxPageCount = 0;
    protected final int HANDLER_SYNC_VIEW_DATA = 1;
    protected final int HANDLER_SYNC_VIEW_STATUS = 2;
    protected final int HANDLER_APPEND_DATA = 3;
    protected final int HANDLER_START_LOAD_DATA = 4;
    protected MessageHandler mHandler = new MessageHandler(){

        @Override
        public void handleMessage(Message msg) {
            DataView dataView = DataLoadControl.this.mAdapter.getDataView();
            switch (msg.what) {
                case 1: {
                    if (null == dataView) break;
                    dataView.notifySyncDataSet(false);
                    break;
                }
                case 2: {
                    if (null == dataView) break;
                    dataView.notifySyncDataSet(true);
                    break;
                }
                case 3: {
                    DataLoadControl.this.performAppendData();
                    break;
                }
                case 4: {
                    DataLoadControl.this.performLoadData();
                }
            }
        }
    };

    public DataLoadControl(DataAdapter adapter) {
        this.mAdapter = adapter;
    }

    public void appendDataAndRefreshView(DataResult result, boolean isDataFromLocal) {
        DataView dataView;
        this.mDataLoadProcessing = false;
        this.mDataHasSetup = true;
        this.mDataLoadNoError = this.mDataList.append(result);
        if (null != result) {
            this.mDataList.message = result.message;
        }
        if (isDataFromLocal) {
            this.mPageAt = (int)Math.ceil((float)this.mDataList.getItemsCount() / (float)this.mPageSize);
            if (this.mPageAt < 0) {
                this.mPageAt = 0;
            }
        } else if (this.mDataLoadNoError) {
            ++this.mPageAt;
        }
        if (this.mDataLoadNoError) {
            this.mMaxPageCount = (int)Math.ceil((float)this.mDataList.totalcount / (float)this.mPageSize);
        }
        if (null != (dataView = this.mAdapter.getDataView())) {
            dataView.notifySyncDataSet(false);
        }
    }

    public DataLoadControl setKeepDataWhenOnRefresh(boolean keepData) {
        this.mKeepDataWhenOnRefresh = keepData;
        return this;
    }

    public DataItem getDataItem(int position) {
        return this.mDataList.getItem(position);
    }

    public int getDataCount() {
        return this.mDataList.getItemsCount();
    }

    public int getTotalCount() {
        return this.mDataList.totalcount;
    }

    public DataResult getDataList() {
        return this.mDataList;
    }

    public boolean getDataHasSetup() {
        return this.mDataHasSetup;
    }

    public boolean getDataLoadProcessing() {
        return this.mDataLoadProcessing;
    }

    public boolean getDataLoadNoError() {
        return this.mDataLoadNoError;
    }

    public boolean getDataLoadCompleted() {
        return !this.mDataLoadProcessing && this.mDataLoadNoError && (this.mDataList.totalcount <= this.mDataList.getItemsCount() || this.mPageAt == this.mMaxPageCount);
    }

    public void setPageSize(int size) {
        this.mPageSize = size < 1 ? 10 : size;
    }

    public int getPageSize() {
        return this.mPageSize;
    }

    public int getPageAt() {
        return this.mPageAt;
    }

    public int getMaxPageCount() {
        return this.mMaxPageCount;
    }

    public void calculateCurrentPage() {
        this.mPageAt = (int)Math.floor((float)this.mDataList.getItemsCount() / (float)this.mPageSize);
    }

    public void setOnDataLoadListener(OnDataLoadListener l) {
        this.mOnDataLoadListener = l;
    }

    public OnDataLoadListener getOnDataLoadListener() {
        return this.mOnDataLoadListener;
    }

    public void setOnDataRefreshedListener(OnDataRefreshedListener l) {
        this.mDataRefreshedListener = l;
    }

    public OnDataRefreshedListener getOnDataRefreshedListener() {
        return this.mDataRefreshedListener;
    }

    public DataLoader getDataLoader() {
        return this.mDataLoader;
    }

    public synchronized void setDataLoader(DataLoader dataLoader, boolean autoStartLoadData) {
        this.mDataLoader = dataLoader;
        if (autoStartLoadData) {
            this.prepareToLoadData();
        }
    }

    public synchronized void refreshData() {
        if (null == this.mDataLoader || this.mDataLoadProcessing) {
            return;
        }
        this.mDataRefreshNow = true;
        this.mDataLoadNoError = true;
        if (!this.mKeepDataWhenOnRefresh) {
            this.mDataList.clear();
            this.mPageAt = 0;
            this.mMaxPageCount = 0;
            DataView dataView = this.mAdapter.getDataView();
            if (null != dataView) {
                dataView.notifySyncDataSet(false);
            }
        }
        this.prepareToLoadData();
    }

    public synchronized void prepareToLoadData() {
        if (null == this.mDataLoader || this.mDataLoadProcessing) {
            return;
        }
        if (null != this.mDataLoadThread && this.mDataLoadThread.isAlive()) {
            return;
        }
        if (this.mDataLoadCalled) {
            return;
        }
        this.mDataLoadCalled = true;
        DataView dataView = this.mAdapter.getDataView();
        if (null != dataView) {
            dataView.callEventsBeforeLoadData(this.mAdapter);
        }
        if (Thread.currentThread().getId() == this.mMainThreadID) {
            this.performLoadData();
        } else {
            this.mHandler.sendEmptyMessage(4);
        }
    }

    private void performAppendData() {
        DataView dataView;
        boolean needAppendData = true;
        boolean dataHasRefreshed = this.mDataRefreshNow;
        if (this.mDataRefreshNow) {
            this.mDataRefreshNow = false;
            if (this.mKeepDataWhenOnRefresh) {
                if (null != this.mNetLoadData && !this.mNetLoadData.hasError) {
                    this.mPageAt = 0;
                    this.mDataList.clear();
                } else if (this.mDataList.isValidListData()) {
                    needAppendData = false;
                }
            } else {
                this.mPageAt = 0;
            }
        }
        if (needAppendData) {
            if (null != this.mNetLoadData) {
                this.appendDataAndRefreshView(this.mNetLoadData, false);
                this.mNetLoadData = null;
            }
        } else {
            this.mDataLoadProcessing = false;
        }
        if (dataHasRefreshed && null != this.mDataRefreshedListener) {
            this.mDataRefreshedListener.onRefreshed(this.mAdapter);
        }
        if (null != (dataView = this.mAdapter.getDataView())) {
            dataView.callEventsAfterLoadData(this.mAdapter);
        }
        this.mDataLoadCalled = false;
    }

    public void statusChangedNotify() {
        if (Thread.currentThread().getId() == this.mMainThreadID) {
            this.mAdapter.notifySyncDataSet(false);
        } else {
            this.mHandler.sendEmptyMessage(1);
        }
    }

    private void performLoadData() {
        this.mDataLoadNoError = true;
        this.mDataLoadProcessing = true;
        DataView dataView = this.mAdapter.getDataView();
        if (null != dataView) {
            dataView.notifySyncDataSet(true);
        }
        try {
            this.mDataLoadThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    int pageAt = DataLoadControl.this.mDataRefreshNow ? 1 : DataLoadControl.this.mPageAt + 1;
                    DataLoadControl.this.mNetLoadData = DataLoadControl.this.mDataLoader.fetchData(DataLoadControl.this.mAdapter, pageAt, DataLoadControl.this.mPageSize);
                    DataLoadControl.this.mHandler.sendEmptyMessage(3);
                    if (null != DataLoadControl.this.mOnDataLoadListener) {
                        DataLoadControl.this.mOnDataLoadListener.onReceived(DataLoadControl.this.mAdapter, pageAt, DataLoadControl.this.mNetLoadData);
                    }
                }
            });
            if (null != dataView && dataView instanceof View) {
                ((View)dataView).post(new Runnable(){

                    @Override
                    public void run() {
                        DataLoadControl.this.mDataLoadThread.start();
                    }
                });
            } else {
                this.mDataLoadThread.start();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

