/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.widget.observablescrollview;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.PointF;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;

public class TouchInterceptionFrameLayout
extends FrameLayout {
    private boolean mIntercepting;
    private boolean mDownMotionEventPended;
    private boolean mBeganFromDownMotionEvent;
    private boolean mChildrenEventsCanceled;
    private PointF mInitialPoint;
    private MotionEvent mPendingDownMotionEvent;
    private TouchInterceptionListener mTouchInterceptionListener;

    public TouchInterceptionFrameLayout(Context context) {
        super(context);
    }

    public TouchInterceptionFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public TouchInterceptionFrameLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public TouchInterceptionFrameLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public void setScrollInterceptionListener(TouchInterceptionListener listener) {
        this.mTouchInterceptionListener = listener;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mTouchInterceptionListener == null) {
            return false;
        }
        switch (ev.getActionMasked()) {
            case 0: {
                this.mInitialPoint = new PointF(ev.getX(), ev.getY());
                this.mPendingDownMotionEvent = MotionEvent.obtainNoHistory((MotionEvent)ev);
                this.mDownMotionEventPended = true;
                this.mBeganFromDownMotionEvent = this.mIntercepting = this.mTouchInterceptionListener.shouldInterceptTouchEvent(ev, false, 0.0f, 0.0f);
                this.mChildrenEventsCanceled = false;
                return this.mIntercepting;
            }
            case 2: {
                if (this.mInitialPoint == null) {
                    this.mInitialPoint = new PointF(ev.getX(), ev.getY());
                }
                float diffX = ev.getX() - this.mInitialPoint.x;
                float diffY = ev.getY() - this.mInitialPoint.y;
                this.mIntercepting = this.mTouchInterceptionListener.shouldInterceptTouchEvent(ev, true, diffX, diffY);
                return this.mIntercepting;
            }
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mTouchInterceptionListener != null) {
            switch (ev.getActionMasked()) {
                case 0: {
                    if (!this.mIntercepting) break;
                    this.mTouchInterceptionListener.onDownMotionEvent(ev);
                    this.duplicateTouchEventForChildren(ev, new MotionEvent[0]);
                    return true;
                }
                case 2: {
                    if (this.mInitialPoint == null) {
                        this.mInitialPoint = new PointF(ev.getX(), ev.getY());
                    }
                    float diffX = ev.getX() - this.mInitialPoint.x;
                    float diffY = ev.getY() - this.mInitialPoint.y;
                    this.mIntercepting = this.mTouchInterceptionListener.shouldInterceptTouchEvent(ev, true, diffX, diffY);
                    if (this.mIntercepting) {
                        if (!this.mBeganFromDownMotionEvent) {
                            this.mBeganFromDownMotionEvent = true;
                            MotionEvent event = MotionEvent.obtainNoHistory((MotionEvent)this.mPendingDownMotionEvent);
                            event.setLocation(ev.getX(), ev.getY());
                            this.mTouchInterceptionListener.onDownMotionEvent(event);
                            this.mInitialPoint = new PointF(ev.getX(), ev.getY());
                            diffY = 0.0f;
                            diffX = 0.0f;
                        }
                        if (!this.mChildrenEventsCanceled) {
                            this.mChildrenEventsCanceled = true;
                            this.duplicateTouchEventForChildren(this.obtainMotionEvent(ev, 3), new MotionEvent[0]);
                        }
                        this.mTouchInterceptionListener.onMoveMotionEvent(ev, diffX, diffY);
                        this.mDownMotionEventPended = true;
                        return true;
                    }
                    if (this.mDownMotionEventPended) {
                        this.mDownMotionEventPended = false;
                        MotionEvent event = MotionEvent.obtainNoHistory((MotionEvent)this.mPendingDownMotionEvent);
                        event.setLocation(ev.getX(), ev.getY());
                        this.duplicateTouchEventForChildren(ev, event);
                    } else {
                        this.duplicateTouchEventForChildren(ev, new MotionEvent[0]);
                    }
                    this.mBeganFromDownMotionEvent = false;
                    this.mChildrenEventsCanceled = false;
                    break;
                }
                case 1: 
                case 3: {
                    this.mBeganFromDownMotionEvent = false;
                    if (this.mIntercepting) {
                        this.mTouchInterceptionListener.onUpOrCancelMotionEvent(ev);
                    }
                    if (!this.mChildrenEventsCanceled) {
                        this.mChildrenEventsCanceled = true;
                        if (this.mDownMotionEventPended) {
                            this.mDownMotionEventPended = false;
                            MotionEvent event = MotionEvent.obtainNoHistory((MotionEvent)this.mPendingDownMotionEvent);
                            event.setLocation(ev.getX(), ev.getY());
                            this.duplicateTouchEventForChildren(ev, event);
                        } else {
                            this.duplicateTouchEventForChildren(ev, new MotionEvent[0]);
                        }
                    }
                    return true;
                }
            }
        }
        return super.onTouchEvent(ev);
    }

    private MotionEvent obtainMotionEvent(MotionEvent base, int action) {
        MotionEvent ev = MotionEvent.obtainNoHistory((MotionEvent)base);
        ev.setAction(action);
        return ev;
    }

    private void duplicateTouchEventForChildren(MotionEvent ev, MotionEvent ... pendingEvents) {
        if (ev == null) {
            return;
        }
        for (int i = this.getChildCount() - 1; 0 <= i; --i) {
            View childView = this.getChildAt(i);
            if (childView == null) continue;
            Rect childRect = new Rect();
            childView.getHitRect(childRect);
            MotionEvent event = MotionEvent.obtainNoHistory((MotionEvent)ev);
            if (!childRect.contains((int)event.getX(), (int)event.getY())) continue;
            float offsetX = -childView.getLeft();
            float offsetY = -childView.getTop();
            boolean consumed = false;
            if (pendingEvents != null) {
                for (MotionEvent pe : pendingEvents) {
                    if (pe == null) continue;
                    MotionEvent peAdjusted = MotionEvent.obtainNoHistory((MotionEvent)pe);
                    peAdjusted.offsetLocation(offsetX, offsetY);
                    consumed |= childView.dispatchTouchEvent(peAdjusted);
                }
            }
            event.offsetLocation(offsetX, offsetY);
            if (consumed |= childView.dispatchTouchEvent(event)) break;
        }
    }

    public static interface TouchInterceptionListener {
        public boolean shouldInterceptTouchEvent(MotionEvent var1, boolean var2, float var3, float var4);

        public void onDownMotionEvent(MotionEvent var1);

        public void onMoveMotionEvent(MotionEvent var1, float var2, float var3);

        public void onUpOrCancelMotionEvent(MotionEvent var1);
    }
}

