/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.util.handler;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import cc.livvy.framework.data.ObjectSessionStore;
import cc.livvy.framework.util.handler.MessageHandler;

public class MessageSender {
    private static final String mObjectName = "messageTargetObject";
    private static Handler mHandler = null;

    public static boolean sendMessage(MessageHandler messageTargetObject, Message msg) {
        MessageSender.initHandler();
        return mHandler.sendMessage(MessageSender.getMessage(messageTargetObject, msg));
    }

    public static boolean sendEmptyMessage(MessageHandler messageTargetObject, int what) {
        MessageSender.initHandler();
        Message msg = mHandler.obtainMessage();
        msg.what = what;
        return MessageSender.sendMessage(messageTargetObject, msg);
    }

    public static boolean sendEmptyMessageDelayed(MessageHandler messageTargetObject, int what, long delayMillis) {
        MessageSender.initHandler();
        Message msg = mHandler.obtainMessage();
        msg.what = what;
        return mHandler.sendMessageDelayed(MessageSender.getMessage(messageTargetObject, msg), delayMillis);
    }

    public static boolean sendMessageDelayed(MessageHandler messageTargetObject, Message msg, long delayMillis) {
        MessageSender.initHandler();
        return mHandler.sendMessageDelayed(MessageSender.getMessage(messageTargetObject, msg), delayMillis);
    }

    public static boolean sendMessageAtTime(MessageHandler messageTargetObject, Message msg, long uptimeMillis) {
        MessageSender.initHandler();
        return mHandler.sendMessageAtTime(MessageSender.getMessage(messageTargetObject, msg), uptimeMillis);
    }

    public static Message obtainMessage() {
        MessageSender.initHandler();
        return Message.obtain((Handler)mHandler);
    }

    public static Message obtainMessage(int what) {
        MessageSender.initHandler();
        return Message.obtain((Handler)mHandler, (int)what);
    }

    private static Message getMessage(MessageHandler messageTargetObject, Message msg) {
        Bundle data;
        if (null == messageTargetObject) {
            return msg;
        }
        if (null == msg) {
            msg = MessageSender.obtainMessage();
        }
        if (null == (data = msg.getData())) {
            data = new Bundle();
        }
        data.putString(mObjectName, ObjectSessionStore.insertObject(messageTargetObject));
        msg.setData(data);
        return msg;
    }

    @SuppressLint(value={"HandlerLeak"})
    private static synchronized void initHandler() {
        if (null != mHandler) {
            return;
        }
        mHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                if (null == msg) {
                    return;
                }
                Bundle data = msg.getData();
                if (null == data) {
                    return;
                }
                MessageHandler object = (MessageHandler)ObjectSessionStore.popObject(data.getString(MessageSender.mObjectName));
                if (null == object) {
                    return;
                }
                object.handleMessage(msg);
            }
        };
    }
}

