/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.data.encrypt;

import android.util.Base64;
import cc.livvy.framework.data.encrypt.Xxtea;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EncryptHandle {
    private static final String ENCRYPT_XXTEA_VERSION = "0001";
    private static final String ENCRYPT_HEAD = "ekzencrypt";
    private static final int LENGTH_ENCRYPT_HEAD = 10;
    private static final int LENGTH_ENCRYPT_VERSION = 4;
    private static final int LENGTH_ENCRYPT_TIMESTAMP = 4;
    private static final int LENGTH_ENCRYPT_BODY_LEN = 6;
    private static final int INDEX_ENCRYPT_VERSION = 10;
    private static final int INDEX_ENCRYPT_TIMESTAMP = 14;
    private static final int INDEX_ENCRYPT_BODY_LEN = 18;
    private static final int INDEX_ENCRYPT_BODY = 24;

    public static String encrypt(String data, String saltSource, String uuid) {
        StringBuffer res = new StringBuffer(ENCRYPT_HEAD);
        SimpleDateFormat formatter = new SimpleDateFormat("HHmm");
        String timeNowHHmm = formatter.format(new Date(System.currentTimeMillis()));
        String salt = saltSource.substring(3, 10);
        String key = uuid + salt + timeNowHHmm;
        String encryptBody = Base64.encodeToString((byte[])Xxtea.encrypt(data.getBytes(Charset.forName("UTF-8")), key.getBytes(Charset.forName("UTF-8"))), (int)2);
        res.append(ENCRYPT_XXTEA_VERSION).append(timeNowHHmm).append(String.format("%06d", encryptBody.length())).append(encryptBody);
        return res.toString();
    }

    public static String decrypt(String data, String saltSource, String uuid) {
        String res = data;
        if (data != null && data.length() >= 22 && ENCRYPT_HEAD.equals(data.substring(0, 10))) {
            String encryptVersion = data.substring(10, 14);
            String encryptTimestampHhmm = data.substring(14, 18);
            int encryptBodyLen = Integer.valueOf(data.substring(18, 24));
            String encryptBody = data.substring(24, encryptBodyLen + 24);
            if (ENCRYPT_XXTEA_VERSION.equals(encryptVersion)) {
                String salt = saltSource.substring(3, 10);
                String key = uuid + salt + encryptTimestampHhmm;
                byte[] decryptByte = Xxtea.decrypt(Base64.decode((String)encryptBody, (int)2), key.getBytes(Charset.forName("UTF-8")));
                if (null != decryptByte) {
                    res = new String(decryptByte);
                }
            }
        }
        return res;
    }

    public static void main(String[] args) {
        String data = "13816161264";
        String encrypt = EncryptHandle.encrypt(data, "1234567890asdfbqwerqwer123", "1234567890asdfbqwerqwer123");
        System.out.println("encrypt:=" + encrypt);
    }
}

