/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.util;

import android.app.ActivityManager;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.os.Process;
import android.text.TextUtils;
import cc.livvy.framework.base.BaseApp;

public class AppUtil {
    public static int appVersionCode() {
        try {
            return BaseApp.getAppContext().getPackageManager().getPackageInfo((String)BaseApp.getAppContext().getPackageName(), (int)0).versionCode;
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public static String appName() {
        String name = null;
        try {
            name = BaseApp.getAppContext().getString(BaseApp.getAppContext().getApplicationInfo().labelRes);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (null == name) {
            name = "";
        }
        return name;
    }

    public static String packageName() {
        String name = null;
        try {
            name = BaseApp.getAppContext().getPackageName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (null == name) {
            name = "";
        }
        return name;
    }

    public static String getCurrentProcessName() {
        try {
            int pid = Process.myPid();
            ActivityManager mActivityManager = (ActivityManager)BaseApp.getAppContext().getSystemService("activity");
            for (ActivityManager.RunningAppProcessInfo appProcess : mActivityManager.getRunningAppProcesses()) {
                if (appProcess.pid != pid) continue;
                return null == appProcess.processName ? "" : appProcess.processName;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    public static String appVersionName() {
        try {
            return BaseApp.getAppContext().getPackageManager().getPackageInfo((String)BaseApp.getAppContext().getPackageName(), (int)0).versionName;
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public static String getClassName(Object x) {
        if (null != x) {
            try {
                String className = x instanceof Class ? ((Class)x).getName() : x.getClass().getName();
                String[] classNames = className.split("\\.");
                return classNames[classNames.length - 1];
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return "";
    }

    public static String getAppRunPath() {
        String path;
        try {
            path = BaseApp.getAppContext().getFilesDir().getAbsolutePath();
        }
        catch (Throwable e) {
            path = "";
        }
        return path;
    }

    public static String getPackagePath() {
        String path;
        try {
            path = BaseApp.getAppContext().getPackageResourcePath();
        }
        catch (Throwable e) {
            path = "";
        }
        return path;
    }

    public static String appSignatures() {
        String signatures = null;
        try {
            signatures = AppUtil.getPackageSignatures(AppUtil.packageName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (null == signatures) {
            signatures = "";
        }
        return signatures;
    }

    public static String getPackageSignatures(String packageName) {
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            return null;
        }
        PackageInfo packageInfo = null;
        try {
            packageInfo = BaseApp.getAppContext().getPackageManager().getPackageInfo(packageName, 64);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (null == packageInfo) {
            return null;
        }
        Signature[] signs = packageInfo.signatures;
        if (null == signs || signs.length == 0) {
            return null;
        }
        return signs[0].toCharsString();
    }
}

