/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.http.request;

import cc.livvy.framework.http.callback.Callback;
import cc.livvy.framework.http.request.RequestCall;
import cc.livvy.framework.http.utils.Exceptions;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import java.util.Map;

public abstract class OkHttpRequest {
    protected String url;
    protected Object tag;
    protected Map<String, String> params;
    protected Map<String, String> headers;
    protected Request.Builder builder = new Request.Builder();

    protected OkHttpRequest(String url, Object tag, Map<String, String> params, Map<String, String> headers) {
        this.url = url;
        this.tag = tag;
        this.params = params;
        this.headers = headers;
        if (url == null) {
            Exceptions.illegalArgument("url can not be null.");
        }
    }

    protected abstract RequestBody buildRequestBody();

    protected RequestBody wrapRequestBody(RequestBody requestBody, Callback callback) {
        return requestBody;
    }

    protected abstract Request buildRequest(Request.Builder var1, RequestBody var2);

    public RequestCall build() {
        return new RequestCall(this);
    }

    public Request generateRequest(Callback callback) {
        RequestBody requestBody = this.wrapRequestBody(this.buildRequestBody(), callback);
        this.prepareBuilder();
        return this.buildRequest(this.builder, requestBody);
    }

    private void prepareBuilder() {
        this.builder.url(this.url).tag(this.tag);
        this.appendHeaders();
    }

    protected void appendHeaders() {
        Headers.Builder headerBuilder = new Headers.Builder();
        if (this.headers == null || this.headers.isEmpty()) {
            return;
        }
        for (String key : this.headers.keySet()) {
            headerBuilder.add(key, this.headers.get(key));
        }
        this.builder.headers(headerBuilder.build());
    }
}

