/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.data.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import cc.livvy.framework.data.model.DataItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public final class DataItemArray
implements Parcelable {
    private static final int CURRENT_PARCEL_VERSION = 1;
    protected final List<Object> mItems = new ArrayList<Object>();
    public static final Parcelable.Creator<DataItemArray> CREATOR = new Parcelable.Creator<DataItemArray>(){

        public DataItemArray createFromParcel(Parcel in) {
            return new DataItemArray(in);
        }

        public DataItemArray[] newArray(int size) {
            return new DataItemArray[size];
        }
    };

    public DataItemArray() {
    }

    public DataItemArray(JSONArray jsonArray) {
        this.appendJSONArray(jsonArray);
    }

    public DataItemArray(Parcel in) {
        this.fromParcel(in);
    }

    public final boolean fromParcel(Parcel in) {
        try {
            int parcelVersion = in.readInt();
            if (parcelVersion != 1) {
                throw new Exception("DataItemArray.fromParcel(in): unkown parcel version: " + parcelVersion);
            }
            this.fromParcelV1(in);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public void removeLastItem() {
        if (this.mItems.size() < 1) {
            return;
        }
        this.mItems.remove(this.size() - 1);
    }

    public void remove(Object obj) {
        if (null == obj) {
            return;
        }
        if (this.mItems.contains(obj)) {
            this.mItems.remove(obj);
        }
    }

    public void remove(int position) {
        if (position < 0 || position >= this.size()) {
            return;
        }
        this.mItems.remove(position);
    }

    public void removeItemsEquals(DataItem item) {
        if (null == item) {
            return;
        }
        for (int i = this.mItems.size() - 1; i >= 0; --i) {
            Object obj = this.mItems.get(i);
            if (!(obj instanceof DataItem) || !obj.equals(item)) continue;
            this.mItems.remove(obj);
        }
    }

    public DataItem firstItemMatches(String key, String value) {
        if (null == key) {
            return null;
        }
        for (int i = 0; i < this.mItems.size(); ++i) {
            Object obj = this.mItems.get(i);
            if (!(obj instanceof DataItem) || !((DataItem)obj).matches(key, value)) continue;
            return (DataItem)obj;
        }
        return null;
    }

    public void removeItemsMatches(String key, String value) {
        if (null == key || null == key) {
            return;
        }
        for (int i = this.mItems.size() - 1; i >= 0; --i) {
            Object obj = this.mItems.get(i);
            if (!(obj instanceof DataItem) || !((DataItem)obj).matches(key, value)) continue;
            this.mItems.remove(obj);
        }
    }

    public DataItemArray clear() {
        this.mItems.clear();
        return this;
    }

    public <T> List<T> getItems() {
        ArrayList<Object> itemList = new ArrayList<Object>();
        for (Object object : this.mItems) {
            itemList.add(object);
        }
        return itemList;
    }

    public DataItemArray makeCopy() {
        DataItemArray newCopy = new DataItemArray();
        for (Object newO : this.mItems) {
            if (newO instanceof DataItem) {
                newCopy.mItems.add(((DataItem)newO).makeCopy());
                continue;
            }
            if (newO instanceof DataItemArray) {
                newCopy.mItems.add(((DataItemArray)newO).makeCopy());
                continue;
            }
            newCopy.mItems.add(newO);
        }
        return newCopy;
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataItemArray)) {
            return false;
        }
        List<Object> oItems = ((DataItemArray)o).mItems;
        if (oItems.size() != this.mItems.size()) {
            return false;
        }
        for (int i = 0; i < this.mItems.size(); ++i) {
            Object oo = oItems.get(i);
            Object mo = this.mItems.get(i);
            if (!oo.getClass().equals(mo.getClass())) {
                return false;
            }
            if (oo.equals(mo)) continue;
            return false;
        }
        return true;
    }

    public Object get(int index) {
        if (index < 0 || index >= this.mItems.size()) {
            return null;
        }
        return this.mItems.get(index);
    }

    public DataItem getItem(int index) {
        Object item = this.get(index);
        if (null == item) {
            return null;
        }
        if (!(item instanceof DataItem)) {
            return new DataItem();
        }
        return (DataItem)item;
    }

    public synchronized DataItemArray syncItemsDataFromKey(String fromKey, String toKey) {
        if (TextUtils.isEmpty((CharSequence)fromKey) || TextUtils.isEmpty((CharSequence)toKey) || fromKey.equals(toKey)) {
            return this;
        }
        for (int i = 0; i < this.size(); ++i) {
            DataItem item = this.getItem(i);
            item.syncDataFromKey(fromKey, toKey);
        }
        return this;
    }

    public String getString(int index) {
        Object item = this.get(index);
        if (null == item) {
            return "";
        }
        if (item instanceof String) {
            return (String)item;
        }
        if (item != null) {
            return String.valueOf(item);
        }
        return "";
    }

    public int getInt(int index) {
        Object item = this.get(index);
        if (null == item) {
            return 0;
        }
        if (item instanceof Integer) {
            return (Integer)item;
        }
        if (item instanceof Number) {
            return ((Number)item).intValue();
        }
        if (item instanceof String) {
            try {
                return (int)Double.parseDouble((String)item);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public final int size() {
        return this.mItems.size();
    }

    public boolean add(Object item) {
        return this.add(item, -1, null);
    }

    public boolean add(Object item, int position) {
        return this.add(item, position, null);
    }

    public boolean add(Object item, int position, String uniqueKey) {
        if (item == null) {
            return false;
        }
        if (item instanceof DataItem && !TextUtils.isEmpty((CharSequence)uniqueKey)) {
            String checkValue = ((DataItem)item).getString(uniqueKey);
            for (Object obj : this.mItems) {
                String tempValue;
                if (!(obj instanceof DataItem) || !(tempValue = ((DataItem)obj).getString(uniqueKey)).equals(checkValue)) continue;
                return true;
            }
        }
        if (item instanceof DataItemArray || item instanceof DataItem || item instanceof String || item instanceof Long || item instanceof Integer || item instanceof Double || item instanceof Number || item instanceof Boolean) {
            if (position < 0 || position >= this.mItems.size()) {
                return this.mItems.add(item);
            }
            this.mItems.add(position, item);
            return true;
        }
        return false;
    }

    public DataItemArray append(DataItemArray items) {
        if (null != items) {
            for (Object item : items.mItems) {
                this.mItems.add(item);
            }
        }
        return this;
    }

    public void Dump() {
        for (int i = 0; i < this.mItems.size(); ++i) {
            Log.v((String)"Dump", (String)("  items[" + i + "] => " + this.mItems.get(i).toString()));
        }
    }

    public String toString() {
        return this.toJSONArray().toString();
    }

    private void fromParcelV1(Parcel in) throws Throwable {
        int itemCount = in.readInt();
        block10: for (int i = 0; i < itemCount; ++i) {
            byte keyType = in.readByte();
            switch (keyType) {
                case 111: {
                    DataItem item = new DataItem();
                    if (!item.fromParcel(in)) {
                        throw new Exception("DataItemArray.fromParcelV1(in): read DataItem type error!");
                    }
                    this.mItems.add(item);
                    continue block10;
                }
                case 97: {
                    DataItemArray items = new DataItemArray();
                    if (!items.fromParcel(in)) {
                        throw new Exception("DataItemArray.fromParcelV1(in): read DataItemArray type error!");
                    }
                    this.mItems.add(items);
                    continue block10;
                }
                case 115: {
                    this.mItems.add(in.readString());
                    continue block10;
                }
                case 108: {
                    this.mItems.add(in.readLong());
                    continue block10;
                }
                case 105: {
                    this.mItems.add(in.readInt());
                    continue block10;
                }
                case 100: {
                    this.mItems.add(in.readDouble());
                    continue block10;
                }
                case 110: {
                    Number number = (Number)in.readSerializable();
                    this.mItems.add(number);
                    continue block10;
                }
                case 98: {
                    Boolean bool = (Boolean)in.readSerializable();
                    this.mItems.add(bool);
                    continue block10;
                }
                default: {
                    throw new Exception("DataItemArray.fromParcelV1(in): unkown value type: " + keyType);
                }
            }
        }
    }

    public final void appendJSONArray(JSONArray jsonArray) {
        if (null != jsonArray) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                Object jo = jsonArray.opt(i);
                if (jo instanceof JSONObject) {
                    this.mItems.add(new DataItem((JSONObject)jo));
                    continue;
                }
                if (jo instanceof JSONArray) {
                    this.mItems.add(new DataItemArray((JSONArray)jo));
                    continue;
                }
                if (!(jo instanceof String) && !(jo instanceof Long) && !(jo instanceof Integer) && !(jo instanceof Double) && !(jo instanceof Number) && !(jo instanceof Boolean)) continue;
                this.mItems.add(jo);
            }
        }
    }

    public final JSONArray toJSONArray() {
        JSONArray jsonArray = new JSONArray();
        try {
            for (int i = 0; i < this.mItems.size(); ++i) {
                Object jo = this.mItems.get(i);
                if (jo instanceof DataItem) {
                    jsonArray.put((Object)((DataItem)jo).toJSONObject());
                    continue;
                }
                if (jo instanceof DataItemArray) {
                    jsonArray.put((Object)((DataItemArray)jo).toJSONArray());
                    continue;
                }
                if (!(jo instanceof String) && !(jo instanceof Long) && !(jo instanceof Integer) && !(jo instanceof Double) && !(jo instanceof Number) && !(jo instanceof Boolean)) continue;
                jsonArray.put(jo);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return jsonArray;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(1);
        dest.writeInt(this.mItems.size());
        for (Object jo : this.mItems) {
            byte keyType;
            if (jo instanceof DataItem) {
                keyType = 111;
                dest.writeByte(keyType);
                ((DataItem)jo).writeToParcel(dest, flags);
                continue;
            }
            if (jo instanceof DataItemArray) {
                keyType = 97;
                dest.writeByte(keyType);
                ((DataItemArray)jo).writeToParcel(dest, flags);
                continue;
            }
            if (jo instanceof String) {
                keyType = 115;
                dest.writeByte(keyType);
                dest.writeString((String)jo);
                continue;
            }
            if (jo instanceof Long) {
                keyType = 108;
                dest.writeByte(keyType);
                dest.writeLong(((Long)jo).longValue());
                continue;
            }
            if (jo instanceof Integer) {
                keyType = 105;
                dest.writeByte(keyType);
                dest.writeInt(((Integer)jo).intValue());
                continue;
            }
            if (jo instanceof Double) {
                keyType = 100;
                dest.writeByte(keyType);
                dest.writeDouble(((Double)jo).doubleValue());
                continue;
            }
            if (jo instanceof Number) {
                keyType = 110;
                dest.writeByte(keyType);
                dest.writeSerializable((Serializable)((Number)jo));
                continue;
            }
            if (jo instanceof Boolean) {
                keyType = 98;
                dest.writeByte(keyType);
                dest.writeSerializable((Serializable)((Boolean)jo));
                continue;
            }
            keyType = 115;
            dest.writeByte(keyType);
            dest.writeString("");
        }
    }
}

