/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.adapter;

import android.content.Context;
import cc.livvy.framework.adapter.BaseEasyRecyclerAdapter;
import cc.livvy.framework.adapter.ItemViewHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EasyRecyclerAdapter<T>
extends BaseEasyRecyclerAdapter<T> {
    private List<T> mListItems;

    public EasyRecyclerAdapter(Context context, Class<? extends ItemViewHolder> itemViewHolderClass, List<T> listItems) {
        super(context, itemViewHolderClass);
        this.setItems(listItems);
    }

    public EasyRecyclerAdapter(Context context, Class<? extends ItemViewHolder> itemViewHolderClass) {
        super(context, itemViewHolderClass);
        this.mListItems = new ArrayList<T>();
    }

    public EasyRecyclerAdapter(Context context, Class<? extends ItemViewHolder> itemViewHolderClass, List<T> listItems, Object listener) {
        super(context, itemViewHolderClass, listener);
        this.setItems(listItems);
    }

    public EasyRecyclerAdapter(Context context, Class<? extends ItemViewHolder> itemViewHolderClass, Object listener) {
        super(context, itemViewHolderClass, listener);
        this.mListItems = new ArrayList<T>();
    }

    public void setItems(List<T> listItems) {
        this.mListItems = listItems;
        this.notifyDataSetChanged();
    }

    public void setItemsWithoutNotifying(List<T> listItems) {
        this.mListItems = listItems;
    }

    public List<T> getItems() {
        return this.mListItems;
    }

    public void addItem(T item) {
        this.mListItems.add(item);
        this.notifyItemInserted(this.mListItems.indexOf(item));
    }

    public boolean removeItem(T item) {
        int index = this.mListItems.indexOf(item);
        if (index < 0) {
            return false;
        }
        this.mListItems.remove(index);
        this.notifyItemRemoved(index);
        return true;
    }

    public boolean addItems(Collection<T> items) {
        if (items.isEmpty()) {
            return false;
        }
        int previousSize = this.getItemCount();
        if (this.mListItems.addAll(items)) {
            this.notifyItemRangeInserted(previousSize, items.size());
            return true;
        }
        return false;
    }

    public boolean removeItems(Collection<? extends T> items) {
        if (this.mListItems.removeAll(items)) {
            this.notifyDataSetChanged();
            return true;
        }
        return false;
    }

    @Override
    public T getItem(int position) {
        return this.mListItems.get(position);
    }

    public int getItemCount() {
        return this.mListItems.size();
    }
}

