/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import cc.livvy.framework.adapter.EasyAdapterUtil;
import cc.livvy.framework.adapter.ItemViewHolder;
import cc.livvy.framework.adapter.PositionInfo;

public abstract class BaseEasyRecyclerAdapter<T>
extends RecyclerView.Adapter<RecyclerViewHolder> {
    private Class mItemViewHolderClass;
    private LayoutInflater mInflater;
    private Integer mItemLayoutId;
    private Object mListener;

    public BaseEasyRecyclerAdapter(Context context, Class<? extends ItemViewHolder> itemViewHolderClass) {
        this.init(context, itemViewHolderClass);
    }

    public BaseEasyRecyclerAdapter(Context context, Class<? extends ItemViewHolder> itemViewHolderClass, Object listener) {
        this.init(context, itemViewHolderClass);
        this.mListener = listener;
    }

    private void init(Context context, Class<? extends ItemViewHolder> itemViewHolderClass) {
        this.mItemViewHolderClass = itemViewHolderClass;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mItemLayoutId = EasyAdapterUtil.parseItemLayoutId(itemViewHolderClass);
    }

    public abstract T getItem(int var1);

    public RecyclerViewHolder onCreateViewHolder(ViewGroup parent, int i) {
        View itemView = this.mInflater.inflate(this.mItemLayoutId.intValue(), parent, false);
        ItemViewHolder itemViewHolder = EasyAdapterUtil.createViewHolder(itemView, this.mItemViewHolderClass);
        itemViewHolder.setListener(this.mListener);
        itemViewHolder.onSetListeners();
        return new RecyclerViewHolder(itemViewHolder);
    }

    public void onBindViewHolder(RecyclerViewHolder recyclerViewHolder, int position) {
        T item = this.getItem(position);
        ItemViewHolder itemViewHolder = recyclerViewHolder.itemViewHolder;
        PositionInfo positionInfo = new PositionInfo(position, position == 0, position == this.getItemCount() - 1);
        itemViewHolder.setItem(item);
        itemViewHolder.onSetValues(item, positionInfo);
    }

    static class RecyclerViewHolder
    extends RecyclerView.ViewHolder {
        ItemViewHolder itemViewHolder;

        public RecyclerViewHolder(ItemViewHolder itemViewHolder) {
            super(itemViewHolder.getView());
            this.itemViewHolder = itemViewHolder;
        }
    }
}

