/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import cc.livvy.framework.adapter.EasyAdapterUtil;
import cc.livvy.framework.adapter.ItemViewHolder;
import cc.livvy.framework.adapter.PositionInfo;

public abstract class BaseEasyAdapter<T>
extends BaseAdapter {
    private Class<? extends ItemViewHolder> mItemViewHolderClass;
    private LayoutInflater mInflater;
    private Integer mItemLayoutId;
    private Object mListener;

    public BaseEasyAdapter(Context context, Class<? extends ItemViewHolder> itemViewHolderClass) {
        this.init(context, itemViewHolderClass);
    }

    public BaseEasyAdapter(Context context, Class<? extends ItemViewHolder> itemViewHolderClass, Object listener) {
        this.init(context, itemViewHolderClass);
        this.mListener = listener;
    }

    private void init(Context context, Class<? extends ItemViewHolder> itemViewHolderClass) {
        this.mItemViewHolderClass = itemViewHolderClass;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mItemLayoutId = EasyAdapterUtil.parseItemLayoutId(itemViewHolderClass);
    }

    public abstract T getItem(int var1);

    public View getView(int position, View convertView, ViewGroup parent) {
        ItemViewHolder holder;
        if (convertView == null) {
            convertView = this.mInflater.inflate(this.mItemLayoutId.intValue(), parent, false);
            holder = EasyAdapterUtil.createViewHolder(convertView, this.mItemViewHolderClass);
            holder.setListener(this.mListener);
            holder.onSetListeners();
            if (convertView != null) {
                convertView.setTag((Object)holder);
            }
        } else {
            holder = (ItemViewHolder)convertView.getTag();
        }
        T item = this.getItem(position);
        holder.setItem(item);
        PositionInfo positionInfo = new PositionInfo(position, position == 0, position == this.getCount() - 1);
        holder.onSetValues(item, positionInfo);
        return convertView;
    }
}

