/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.widget.observablescrollview;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ScrollView;
import cc.livvy.framework.widget.observablescrollview.ObservableScrollViewCallbacks;
import cc.livvy.framework.widget.observablescrollview.ScrollState;
import cc.livvy.framework.widget.observablescrollview.Scrollable;
import java.util.ArrayList;
import java.util.List;

public class ObservableScrollView
extends ScrollView
implements Scrollable {
    private int mPrevScrollY;
    private int mScrollY;
    private ObservableScrollViewCallbacks mCallbacks;
    private List<ObservableScrollViewCallbacks> mCallbackCollection;
    private ScrollState mScrollState;
    private boolean mFirstScroll;
    private boolean mDragging;
    private boolean mIntercepted;
    private MotionEvent mPrevMoveEvent;
    private ViewGroup mTouchInterceptionViewGroup;

    public ObservableScrollView(Context context) {
        super(context);
    }

    public ObservableScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ObservableScrollView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        this.mPrevScrollY = ss.prevScrollY;
        this.mScrollY = ss.scrollY;
        super.onRestoreInstanceState(ss.getSuperState());
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.prevScrollY = this.mPrevScrollY;
        ss.scrollY = this.mScrollY;
        return ss;
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (this.mCallbacks != null || this.mCallbackCollection != null) {
            this.mScrollY = t;
            this.dispatchOnScrollChanged(t, this.mFirstScroll, this.mDragging);
            if (this.mFirstScroll) {
                this.mFirstScroll = false;
            }
            if (this.mPrevScrollY < t) {
                this.mScrollState = ScrollState.UP;
            } else if (t < this.mPrevScrollY) {
                this.mScrollState = ScrollState.DOWN;
            }
            this.mPrevScrollY = t;
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mCallbacks != null || this.mCallbackCollection != null) {
            switch (ev.getActionMasked()) {
                case 0: {
                    this.mDragging = true;
                    this.mFirstScroll = true;
                    this.dispatchOnDownMotionEvent();
                }
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mCallbacks != null || this.mCallbackCollection != null) {
            switch (ev.getActionMasked()) {
                case 1: 
                case 3: {
                    this.mIntercepted = false;
                    this.mDragging = false;
                    this.dispatchOnUpOrCancelMotionEvent(this.mScrollState);
                    break;
                }
                case 2: {
                    if (this.mPrevMoveEvent == null) {
                        this.mPrevMoveEvent = ev;
                    }
                    float diffY = ev.getY() - this.mPrevMoveEvent.getY();
                    this.mPrevMoveEvent = MotionEvent.obtainNoHistory((MotionEvent)ev);
                    if (!((float)this.getCurrentScrollY() - diffY <= 0.0f)) break;
                    if (this.mIntercepted) {
                        return false;
                    }
                    final ViewGroup parent = this.mTouchInterceptionViewGroup == null ? (ViewGroup)this.getParent() : this.mTouchInterceptionViewGroup;
                    float offsetX = 0.0f;
                    float offsetY = 0.0f;
                    for (ObservableScrollView v = this; v != null && v != parent; v = (View)v.getParent()) {
                        offsetX += (float)(v.getLeft() - v.getScrollX());
                        offsetY += (float)(v.getTop() - v.getScrollY());
                    }
                    final MotionEvent event = MotionEvent.obtainNoHistory((MotionEvent)ev);
                    event.offsetLocation(offsetX, offsetY);
                    if (parent.onInterceptTouchEvent(event)) {
                        this.mIntercepted = true;
                        event.setAction(0);
                        this.post(new Runnable(){

                            @Override
                            public void run() {
                                parent.dispatchTouchEvent(event);
                            }
                        });
                        return false;
                    }
                    return super.onTouchEvent(ev);
                }
            }
        }
        return super.onTouchEvent(ev);
    }

    @Override
    public void setScrollViewCallbacks(ObservableScrollViewCallbacks listener) {
        this.mCallbacks = listener;
    }

    @Override
    public void addScrollViewCallbacks(ObservableScrollViewCallbacks listener) {
        if (this.mCallbackCollection == null) {
            this.mCallbackCollection = new ArrayList<ObservableScrollViewCallbacks>();
        }
        this.mCallbackCollection.add(listener);
    }

    @Override
    public void removeScrollViewCallbacks(ObservableScrollViewCallbacks listener) {
        if (this.mCallbackCollection != null) {
            this.mCallbackCollection.remove(listener);
        }
    }

    @Override
    public void clearScrollViewCallbacks() {
        if (this.mCallbackCollection != null) {
            this.mCallbackCollection.clear();
        }
    }

    @Override
    public void setTouchInterceptionViewGroup(ViewGroup viewGroup) {
        this.mTouchInterceptionViewGroup = viewGroup;
    }

    @Override
    public void scrollVerticallyTo(int y) {
        this.scrollTo(0, y);
    }

    @Override
    public int getCurrentScrollY() {
        return this.mScrollY;
    }

    private void dispatchOnDownMotionEvent() {
        if (this.mCallbacks != null) {
            this.mCallbacks.onDownMotionEvent();
        }
        if (this.mCallbackCollection != null) {
            for (int i = 0; i < this.mCallbackCollection.size(); ++i) {
                ObservableScrollViewCallbacks callbacks = this.mCallbackCollection.get(i);
                callbacks.onDownMotionEvent();
            }
        }
    }

    private void dispatchOnScrollChanged(int scrollY, boolean firstScroll, boolean dragging) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onScrollChanged(scrollY, firstScroll, dragging);
        }
        if (this.mCallbackCollection != null) {
            for (int i = 0; i < this.mCallbackCollection.size(); ++i) {
                ObservableScrollViewCallbacks callbacks = this.mCallbackCollection.get(i);
                callbacks.onScrollChanged(scrollY, firstScroll, dragging);
            }
        }
    }

    private void dispatchOnUpOrCancelMotionEvent(ScrollState scrollState) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onUpOrCancelMotionEvent(scrollState);
        }
        if (this.mCallbackCollection != null) {
            for (int i = 0; i < this.mCallbackCollection.size(); ++i) {
                ObservableScrollViewCallbacks callbacks = this.mCallbackCollection.get(i);
                callbacks.onUpOrCancelMotionEvent(scrollState);
            }
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        int prevScrollY;
        int scrollY;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.prevScrollY = in.readInt();
            this.scrollY = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.prevScrollY);
            out.writeInt(this.scrollY);
        }
    }
}

