/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.http;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.View;
import android.widget.Toast;
import cc.livvy.framework.base.BaseApp;
import cc.livvy.framework.data.encrypt.EncryptHandle;
import cc.livvy.framework.data.model.DataResult;
import cc.livvy.framework.http.OkHttpUtils;
import cc.livvy.framework.http.builder.PostFormBuilder;
import cc.livvy.framework.http.callback.Callback;
import cc.livvy.framework.log.LogLevel;
import cc.livvy.framework.manager.ActivityManager;
import cc.livvy.framework.manager.SplashManager;
import cc.livvy.framework.util.DeviceUtil;
import cc.livvy.framework.widget.AlertDialog;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class UnifyHttpClient {
    private static final int HTTP_STATUS_WITHOUT_PERMISSION = -4;
    private static final int HTTP_STATUS_UPGRADE = -2;
    private static final int HTTP_STATUS_NETWORK_ERROR = 10001;
    private static final int HTTP_CONNECT_ERROR_UI_REFRESH = 3;
    public static LogLevel mLogLevel = LogLevel.FULL;
    private static UIHandler mHandler = new UIHandler();
    private static UnifyHttpClient instance;
    private static OkHttpUtils mHttpUtils;

    public UnifyHttpClient() {
        mHttpUtils = new OkHttpUtils();
    }

    public static UnifyHttpClient getInstance() {
        if (null == instance) {
            instance = new UnifyHttpClient();
        }
        return instance;
    }

    public UnifyHttpClient setHttpLogLevel(LogLevel level) {
        mLogLevel = level;
        if (null == instance) {
            throw new NullPointerException("UnifyHttpClient is null,UnifyHttpClient must init");
        }
        return instance;
    }

    public UnifyHttpClient setConnectTimeout(long time) {
        mHttpUtils.getOkHttpClient().setConnectTimeout(time, TimeUnit.MILLISECONDS);
        if (null == instance) {
            throw new NullPointerException("UnifyHttpClient is null,UnifyHttpClient must init");
        }
        return instance;
    }

    public static DataResult execute(String url, HashMap<String, String> params, @Nullable UnifyHttpCallback callback) {
        if (null == mHttpUtils) {
            throw new NullPointerException("UnifyHttpClient is null,UnifyHttpClient must init");
        }
        if (mLogLevel == LogLevel.FULL) {
            StringBuilder str = new StringBuilder();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (str.length() > 1) {
                    str.append("&");
                }
                str.append(entry.getKey());
                str.append("=");
                str.append(entry.getValue());
            }
            Log.i((String)"httpRequest", (String)"========================params==================================");
            Log.i((String)"httpRequest", (String)("\u8bbf\u95ee\u7684\u5730\u5740: " + url));
            Log.i((String)"httpRequest", (String)("\u8bbf\u95ee\u7684\u53c2\u6570: " + str.toString()));
            Log.i((String)"httpRequest", (String)"========================params==================================");
        }
        if (null == callback) {
            return UnifyHttpClient.execute(url, params, true);
        }
        UnifyHttpClient.execute(url, params, callback, true);
        return null;
    }

    private static DataResult execute(String url, HashMap<String, String> params, boolean isCipher) {
        DataResult result;
        block2: {
            try {
                Response response = ((PostFormBuilder)OkHttpUtils.post().url(url).params(UnifyHttpClient.getEncryptParams(params, isCipher))).build().execute();
                result = UnifyHttpClient.processResponse(response);
            }
            catch (IOException e) {
                result = new DataResult();
                if (!(e instanceof ConnectException)) break block2;
                Message message = new Message();
                message.what = 3;
                mHandler.sendMessage(message);
                result.message = "\u60a8\u7684\u7f51\u7edc\u6709\u4e9b\u95ee\u9898\u54e6";
            }
        }
        return result;
    }

    private static void execute(String url, HashMap<String, String> params, UnifyHttpCallback callback, boolean isCipher) {
        ((PostFormBuilder)OkHttpUtils.post().url(url).params(UnifyHttpClient.getEncryptParams(params, isCipher))).build().execute(callback);
    }

    private static DataResult processResponse(Response response) throws IOException {
        DataResult result;
        if (null == response) {
            throw new NullPointerException("Response is null");
        }
        switch (response.code()) {
            case 200: {
                try {
                    String resultStrEncrypt = response.body().string();
                    String resultStr = EncryptHandle.decrypt(resultStrEncrypt, DeviceUtil.getUUID(), DeviceUtil.getUUID());
                    if (mLogLevel == LogLevel.FULL) {
                        Log.i((String)"===\u8bf7\u6c42\u8def\u5f84:===", (String)response.request().urlString());
                        Log.i((String)"===\u8bf7\u6c42\u8fd4\u56de:===", (String)resultStr);
                        Log.i((String)"===\u8bf7\u6c42code:===", (String)(response.code() + ""));
                    }
                    JSONObject jsonObject = new JSONObject(resultStr);
                    result = new DataResult(jsonObject);
                    if (result.status == -4) {
                        String mSplashAction = SplashManager.getSplashAction();
                        if (!mSplashAction.equals("")) {
                            result.hasError = true;
                            result.message = "\u5440\uff0c\u597d\u50cf\u88ab\u62d2\u7edd\u4e86\u54e6,\u70b9\u51fb\u91cd\u65b0\u52a0\u8f7d\u8bd5\u8bd5 >_<";
                            Intent intent = new Intent(mSplashAction);
                            intent.setFlags(0x10000000);
                            BaseApp.getAppContext().startActivity(intent);
                            break;
                        }
                        throw new NullPointerException("SplashManager is null,SplashManager must init");
                    }
                    if (result.status != -2) break;
                    Message message = new Message();
                    message.what = -2;
                    mHandler.sendMessage(message);
                }
                catch (Throwable e) {
                    result = new DataResult();
                    result.hasError = true;
                    result.localError = true;
                    result.message = "\u56e7\uff0c\u89e3\u6790\u6570\u636e\u5931\u8d25 >_<";
                }
                break;
            }
            case 404: {
                result = new DataResult();
                break;
            }
            case 500: {
                result = new DataResult();
                break;
            }
            default: {
                result = new DataResult();
                result.hasError = true;
                result.localError = true;
                result.message = "\u56e7\uff0c\u83b7\u53d6\u6570\u636e\u51fa\u73b0\u95ee\u9898\u4e86 >_<";
            }
        }
        return result;
    }

    private static HashMap<String, String> getEncryptParams(HashMap<String, String> params, boolean isCipher) {
        if (!isCipher) {
            return params;
        }
        HashMap<String, String> mEncryptParams = new HashMap<String, String>();
        StringBuilder str = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (!(entry.getKey().contains("partner") || entry.getKey().contains("uuid") || entry.getKey().contains("guid") || entry.getKey().contains("ver") || entry.getKey().contains("productname"))) {
                if (str.length() > 1) {
                    str.append("&");
                }
                str.append(entry.getKey());
                str.append("=");
                str.append(entry.getValue());
                continue;
            }
            mEncryptParams.put(entry.getKey(), entry.getValue());
        }
        if (str.length() > 1) {
            mEncryptParams.put("eyBody", EncryptHandle.encrypt(str.toString(), DeviceUtil.getUUID(), DeviceUtil.getUUID()));
        }
        return mEncryptParams;
    }

    public static abstract class UnifyHttpCallback
    extends Callback<DataResult> {
        @Override
        public DataResult parseNetworkResponse(Response response) throws IOException {
            DataResult result = UnifyHttpClient.processResponse(response);
            return result;
        }

        @Override
        public void onError(Request request, Exception e) {
            this.onErrors(request, e);
        }

        @Override
        public DataResult onErrors(Request request, Exception e) {
            if (mLogLevel == LogLevel.FULL) {
                Log.i((String)"===HttpError===", (String)("url:" + request.url().toString()));
                Log.i((String)"===HttpError===", (String)("body:" + request.body().toString()));
                Log.i((String)"===HttpError===", (String)("Exception:" + e.toString()));
            }
            if (e instanceof ConnectException) {
                Message message = new Message();
                message.what = 3;
                mHandler.sendMessage(message);
            }
            DataResult result = new DataResult();
            result.hasError = true;
            result.status = 10001;
            result.message = "\u5440\uff0c\u7f51\u7edc\u8bbf\u95ee\u5931\u8d25\u4e86\u554a >_<";
            return result;
        }
    }

    static class UIHandler
    extends Handler {
        UIHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 3: {
                    Toast.makeText((Context)BaseApp.getAppContext(), (CharSequence)"\u8bf7\u68c0\u67e5\u60a8\u7684\u7f51\u7edc\u662f\u5426\u6b63\u5e38", (int)1).show();
                    break;
                }
                case -2: {
                    final AlertDialog dialog = new AlertDialog((Context)ActivityManager.getCurrentActivity());
                    dialog.setTitle("\u7248\u672c\u8fc7\u4f4e\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u7248\u672c");
                    dialog.setActionButton("\u786e\u5b9a", new View.OnClickListener(){

                        public void onClick(View v) {
                            Uri uri = Uri.parse((String)"http://m.ekuaizhi.com/appdown");
                            Intent intent = new Intent("android.intent.action.VIEW", uri);
                            ActivityManager.getCurrentActivity().startActivity(intent);
                            dialog.dismiss();
                            ActivityManager.finishAllActivities();
                        }
                    }).setCancelButton("\u53d6\u6d88", new View.OnClickListener(){

                        public void onClick(View v) {
                            dialog.dismiss();
                            ActivityManager.finishAllActivities();
                        }
                    });
                    dialog.setCanceledOnTouchOutside(false);
                    dialog.show();
                }
            }
        }
    }
}

