/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.handler;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import cc.livvy.framework.handler.HandlerException;
import cc.livvy.framework.handler.SyncPost;
import java.util.LinkedList;
import java.util.Queue;

final class HandlerPoster
extends Handler {
    private final int ASYNC = 1;
    private final int SYNC = 2;
    private final Queue<Runnable> asyncPool;
    private final Queue<SyncPost> syncPool;
    private final int maxMillisInsideHandleMessage;
    private boolean asyncActive;
    private boolean syncActive;

    HandlerPoster(Looper looper, int maxMillisInsideHandleMessage) {
        super(looper);
        this.maxMillisInsideHandleMessage = maxMillisInsideHandleMessage;
        this.asyncPool = new LinkedList<Runnable>();
        this.syncPool = new LinkedList<SyncPost>();
    }

    void dispose() {
        this.removeCallbacksAndMessages(null);
        this.asyncPool.clear();
        this.syncPool.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void async(Runnable runnable) {
        Queue<Runnable> queue = this.asyncPool;
        synchronized (queue) {
            this.asyncPool.offer(runnable);
            if (!this.asyncActive) {
                this.asyncActive = true;
                if (!this.sendMessage(this.obtainMessage(1))) {
                    throw new HandlerException("Could not send handler message");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sync(SyncPost post) {
        Queue<SyncPost> queue = this.syncPool;
        synchronized (queue) {
            this.syncPool.offer(post);
            if (!this.syncActive) {
                this.syncActive = true;
                if (!this.sendMessage(this.obtainMessage(2))) {
                    throw new HandlerException("Could not send handler message");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleMessage(Message msg) {
        if (msg.what == 1) {
            boolean rescheduled = false;
            try {
                long timeInMethod2;
                long started = SystemClock.uptimeMillis();
                do {
                    Runnable runnable;
                    if ((runnable = this.asyncPool.poll()) == null) {
                        Queue<Runnable> queue = this.asyncPool;
                        synchronized (queue) {
                            runnable = this.asyncPool.poll();
                            if (runnable == null) {
                                this.asyncActive = false;
                                return;
                            }
                        }
                    }
                    runnable.run();
                } while ((timeInMethod2 = SystemClock.uptimeMillis() - started) < (long)this.maxMillisInsideHandleMessage);
                if (!this.sendMessage(this.obtainMessage(1))) {
                    throw new HandlerException("Could not send handler message");
                }
                rescheduled = true;
                return;
            }
            finally {
                this.asyncActive = rescheduled;
            }
        }
        if (msg.what != 2) {
            super.handleMessage(msg);
            return;
        }
        boolean rescheduled = false;
        try {
            long timeInMethod;
            long started = SystemClock.uptimeMillis();
            do {
                SyncPost post;
                if ((post = this.syncPool.poll()) == null) {
                    Queue<SyncPost> timeInMethod2 = this.syncPool;
                    synchronized (timeInMethod2) {
                        post = this.syncPool.poll();
                        if (post == null) {
                            this.syncActive = false;
                            return;
                        }
                    }
                }
                post.run();
            } while ((timeInMethod = SystemClock.uptimeMillis() - started) < (long)this.maxMillisInsideHandleMessage);
            if (!this.sendMessage(this.obtainMessage(2))) {
                throw new HandlerException("Could not send handler message");
            }
            rescheduled = true;
            return;
        }
        finally {
            this.syncActive = rescheduled;
        }
    }
}

