/*
 * Decompiled with CFR 0.152.
 */
package cc.livvy.framework.data.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import cc.livvy.framework.data.model.DataItem;
import cc.livvy.framework.data.model.DataItemArray;
import java.io.Serializable;
import org.json.JSONObject;

public class DataResult
implements Parcelable {
    private static final int CURRENT_PARCEL_VERSION = 1;
    public boolean hasError = false;
    public boolean localError = false;
    public int status = 0;
    public int totalcount = 0;
    public String message = "";
    public final DataItem detailinfo = new DataItem();
    public final DataItemArray items = new DataItemArray();
    private String itemUniqueKey = "";
    private String debuginfo = "";
    public static final Parcelable.Creator<DataResult> CREATOR = new Parcelable.Creator<DataResult>(){

        public DataResult createFromParcel(Parcel in) {
            return new DataResult(in);
        }

        public DataResult[] newArray(int size) {
            return new DataResult[size];
        }
    };

    public DataResult() {
    }

    public DataResult(JSONObject jsonObject) {
        this.appendJSONObject(jsonObject);
    }

    public DataResult(Parcel in) {
        this.fromParcel(in);
    }

    public final boolean fromParcel(Parcel in) {
        try {
            int parcelVersion = in.readInt();
            if (parcelVersion != 1) {
                throw new Exception("DataResult.fromParcel(in): unkown parcel version: " + parcelVersion);
            }
            this.fromParcelV1(in);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public boolean addItem(DataItem item) {
        if (null == item) {
            return false;
        }
        if (this.items.add(item, -1, this.itemUniqueKey)) {
            if (this.totalcount < this.items.size()) {
                this.totalcount = this.items.size();
            }
            return true;
        }
        return false;
    }

    public boolean addItem(int position, DataItem item) {
        if (null == item) {
            return false;
        }
        if (this.items.add(item, position, this.itemUniqueKey)) {
            if (this.totalcount < this.items.size()) {
                this.totalcount = this.items.size();
            }
            return true;
        }
        return false;
    }

    public int getItemsCount() {
        return this.items.size();
    }

    public boolean isValidDetailData() {
        return null != this.detailinfo && !this.hasError && this.detailinfo.size() > 0;
    }

    public boolean isValidListData() {
        return null != this.items && !this.hasError && this.items.size() > 0;
    }

    public Object removeByIndex(int index) {
        if (index < 0 || index >= this.items.mItems.size()) {
            return null;
        }
        Object item = this.items.mItems.remove(index);
        if (null != item) {
            --this.totalcount;
        }
        return item;
    }

    public boolean removeItem(Object item) {
        if (this.items.mItems.remove(item)) {
            --this.totalcount;
            return true;
        }
        return false;
    }

    public DataItem getItem(int index) {
        if (index < 0 || index >= this.items.size()) {
            return null;
        }
        Object item = this.items.get(index);
        if (!(item instanceof DataItem)) {
            return new DataItem();
        }
        return (DataItem)this.items.get(index);
    }

    public DataResult clear() {
        this.items.clear();
        this.detailinfo.clear();
        this.debuginfo = "";
        this.hasError = false;
        this.localError = false;
        this.status = 0;
        this.totalcount = 0;
        this.message = "";
        return this;
    }

    public int getItemID(int index) {
        if (null == this.itemUniqueKey || this.itemUniqueKey.length() < 1) {
            return index;
        }
        DataItem item = this.getItem(index);
        if (item == null || !(item instanceof DataItem)) {
            return index;
        }
        int uniqueID = item.getInt(this.itemUniqueKey);
        if (uniqueID == 0) {
            return index;
        }
        return uniqueID;
    }

    public int getTotalPage(int pageSize) {
        if (pageSize < 1 || this.totalcount < 1) {
            return 0;
        }
        return (int)Math.ceil((float)this.totalcount / (float)pageSize);
    }

    public String getServerErrorMessage() {
        if (!this.hasError || this.localError) {
            return "";
        }
        return this.message;
    }

    public void setItemUniqueKey(String key) {
        this.itemUniqueKey = null == key ? "" : key;
    }

    public DataResult makeCopy() {
        DataResult result = new DataResult();
        result.hasError = this.hasError;
        result.localError = this.localError;
        result.status = this.status;
        result.totalcount = this.totalcount;
        result.message = this.message;
        result.detailinfo.append(this.detailinfo.makeCopy());
        result.items.append(this.items.makeCopy());
        result.itemUniqueKey = this.itemUniqueKey;
        result.debuginfo = this.debuginfo;
        return result;
    }

    public synchronized DataResult syncItemsDataFromKey(String fromKey, String toKey) {
        if (TextUtils.isEmpty((CharSequence)fromKey) || TextUtils.isEmpty((CharSequence)toKey) || fromKey.equals(toKey)) {
            return this;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            DataItem item = this.items.getItem(i);
            item.syncDataFromKey(fromKey, toKey);
        }
        return this;
    }

    public int countItemsWithBooleanValue(String key, boolean value) {
        int startIndex;
        if (this.items.size() < 1) {
            return 0;
        }
        int result = 0;
        for (int i = startIndex = this.items.size() - 1; i > -1; --i) {
            DataItem item = this.getItem(i);
            if (item == null || item.getBool(key) != value) continue;
            ++result;
        }
        return result;
    }

    public int countItemsWithStringValue(String key, String value) {
        int startIndex;
        if (this.items.size() < 1) {
            return 0;
        }
        int result = 0;
        for (int i = startIndex = this.items.size() - 1; i > -1; --i) {
            DataItem item = this.getItem(i);
            if (item == null || !item.getString(key).equals(value)) continue;
            ++result;
        }
        return result;
    }

    public String getItemsIDWithBooleanValue(String key, boolean value) {
        int startIndex;
        if (TextUtils.isEmpty((CharSequence)this.itemUniqueKey)) {
            return "";
        }
        if (this.items.size() < 1) {
            return "";
        }
        String result = "";
        for (int i = startIndex = this.items.size() - 1; i > -1; --i) {
            String ID;
            DataItem item = this.getItem(i);
            if (item == null || item.getBool(key) != value || (ID = item.getString(this.itemUniqueKey)).length() <= 0) continue;
            if (result.length() > 0) {
                result = result + ",";
            }
            result = result + ID;
        }
        return result;
    }

    public boolean removeItemsWithStringValue(String key, String value) {
        int startIndex;
        if (this.items.size() < 1) {
            return true;
        }
        for (int i = startIndex = this.items.size() - 1; i > -1; --i) {
            DataItem item = this.getItem(i);
            if (item == null) {
                return false;
            }
            if (!item.matches(key, value) || null != this.removeByIndex(i)) continue;
            return false;
        }
        return true;
    }

    public boolean setAllItemsToStringValue(String key, String value) {
        if (this.items.size() < 1) {
            return true;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            DataItem item = this.getItem(i);
            if (item == null) {
                return false;
            }
            if (value.equals(item.setString(key, value))) continue;
            return false;
        }
        return true;
    }

    public DataItem firstItemMatches(String key, Boolean value) {
        if (this.items.size() < 1) {
            return null;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            DataItem item;
            Object obj = this.items.get(i);
            if (obj == null || !(obj instanceof DataItem) || !(item = (DataItem)obj).matches(key, value)) continue;
            return item;
        }
        return null;
    }

    public DataItem firstItemMatches(String key, String value) {
        if (this.items.size() < 1) {
            return null;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            DataItem item;
            Object obj = this.items.get(i);
            if (obj == null || !(obj instanceof DataItem) || !(item = (DataItem)obj).matches(key, value)) continue;
            return item;
        }
        return null;
    }

    public boolean setAllItemsToBooleanValue(String key, Boolean value) {
        if (this.items.size() < 1) {
            return true;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            DataItem item = this.getItem(i);
            if (item == null) {
                return false;
            }
            if (item.setBool(key, value)) continue;
            return false;
        }
        return true;
    }

    public boolean removeItemsWithTrueValue(String key) {
        int startIndex;
        if (this.items.size() < 1) {
            return true;
        }
        for (int i = startIndex = this.items.size() - 1; i > -1; --i) {
            DataItem item = this.getItem(i);
            if (item == null || item.isEmpty()) {
                return false;
            }
            if (!item.getBool(key) || null != this.removeByIndex(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataResult)) {
            return false;
        }
        DataResult obj = (DataResult)o;
        if (obj.hasError != this.hasError) {
            return false;
        }
        if (obj.localError != this.localError) {
            return false;
        }
        if (obj.status != this.status) {
            return false;
        }
        if (obj.totalcount != this.totalcount) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)obj.message) != TextUtils.isEmpty((CharSequence)this.message)) {
            return false;
        }
        if (null != obj.message && !obj.message.equals(this.message)) {
            return false;
        }
        if (!obj.detailinfo.equals(this.detailinfo)) {
            return false;
        }
        return obj.items.equals(this.items);
    }

    public void setErrorStack(String str) {
        this.debuginfo = null == str ? "" : str;
    }

    public String getErrorStack() {
        return this.debuginfo;
    }

    private void fromParcelV1(Parcel in) throws Throwable {
        this.hasError = (Boolean)in.readSerializable();
        this.localError = (Boolean)in.readSerializable();
        this.status = in.readInt();
        this.totalcount = in.readInt();
        this.message = in.readString();
        if (!this.detailinfo.fromParcel(in)) {
            throw new Exception("DataResult.fromParcelV1(in): read detailinfo type error!");
        }
        if (!this.items.fromParcel(in)) {
            throw new Exception("DataResult.fromParcelV1(in): read items type error!");
        }
    }

    public boolean appendFront(DataResult result) {
        if (null == result || result.hasError) {
            return false;
        }
        this.totalcount = result.totalcount;
        this.status = result.status;
        this.hasError = result.hasError;
        this.localError = result.localError;
        this.detailinfo.append(result.detailinfo);
        if (result.items.size() > 0) {
            for (int i = result.items.size() - 1; i > -1; --i) {
                this.items.add(result.items.get(i), 0, this.itemUniqueKey);
            }
        }
        if (this.totalcount < this.items.size()) {
            this.totalcount = this.items.size();
        }
        return true;
    }

    public boolean append(DataResult result) {
        if (null == result || result.hasError) {
            return false;
        }
        this.totalcount = result.totalcount;
        this.status = result.status;
        this.hasError = result.hasError;
        this.localError = result.localError;
        this.detailinfo.append(result.detailinfo);
        for (int i = 0; i < result.items.size(); ++i) {
            this.items.add(result.items.get(i), -1, this.itemUniqueKey);
        }
        if (this.totalcount < this.items.size()) {
            this.totalcount = this.items.size();
        }
        return true;
    }

    public boolean append(DataItemArray dataItemArray) {
        if (null == dataItemArray || dataItemArray.size() < 1) {
            return false;
        }
        for (int i = 0; i < dataItemArray.size(); ++i) {
            this.items.add(dataItemArray.get(i), -1, this.itemUniqueKey);
        }
        if (this.totalcount < this.items.size()) {
            this.totalcount = this.items.size();
        }
        return true;
    }

    public void Dump() {
        Log.v((String)"Dump", (String)"==========  [basicInfo] ==========");
        Log.v((String)"Dump", (String)("  .hasError: " + this.hasError));
        Log.v((String)"Dump", (String)("  .localError: " + this.localError));
        Log.v((String)"Dump", (String)("  .status: " + this.status));
        Log.v((String)"Dump", (String)("  .totalcount: " + this.totalcount));
        Log.v((String)"Dump", (String)("  .message: " + this.message));
        Log.v((String)"Dump", (String)("  .debuginfo: " + this.debuginfo));
        Log.v((String)"Dump", (String)"==========  [detailInfo] ==========");
        this.detailinfo.Dump();
        Log.v((String)"Dump", (String)"==========  [dataList] ==========");
        this.items.Dump();
        Log.e((String)"Dump items", (String)(this.items.size() + ""));
    }

    public String toString() {
        return this.toJSONObject().toString();
    }

    public byte[] toBytes() {
        byte[] data = null;
        try {
            Parcel out = Parcel.obtain();
            this.writeToParcel(out, 0);
            out.setDataPosition(0);
            data = out.marshall();
            out.recycle();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return data;
    }

    public static DataResult fromBytes(byte[] bytesData) {
        if (null == bytesData) {
            return new DataResult();
        }
        try {
            Parcel in = Parcel.obtain();
            in.unmarshall(bytesData, 0, bytesData.length);
            in.setDataPosition(0);
            return (DataResult)CREATOR.createFromParcel(in);
        }
        catch (Throwable throwable) {
            return new DataResult();
        }
    }

    public final void appendJSONObject(JSONObject jsonObject) {
        if (null != jsonObject) {
            if (jsonObject.has("result")) {
                boolean bl = this.hasError = !jsonObject.optBoolean("result");
            }
            if (jsonObject.has("localError")) {
                this.localError = jsonObject.optBoolean("localError");
            }
            if (jsonObject.has("status")) {
                this.status = jsonObject.optInt("status");
            }
            if (jsonObject.has("count")) {
                this.totalcount = jsonObject.optInt("count");
            }
            if (jsonObject.has("message")) {
                this.message = jsonObject.optString("message");
            }
            if (jsonObject.has("debuginfo")) {
                this.debuginfo = jsonObject.optString("debuginfo");
            }
            if (jsonObject.has("entity")) {
                this.detailinfo.appendJSONObject(jsonObject.optJSONObject("entity"));
            }
            if (jsonObject.has("list")) {
                this.items.appendJSONArray(jsonObject.optJSONArray("list"));
            }
        }
    }

    public final JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("result", !this.hasError);
            jsonObject.put("hasError", this.hasError);
            jsonObject.put("localError", this.localError);
            jsonObject.put("status", this.status);
            jsonObject.put("totalcount", this.totalcount);
            jsonObject.put("message", (Object)this.message);
            jsonObject.put("debuginfo", (Object)this.debuginfo);
            jsonObject.put("detailinfo", (Object)this.detailinfo.toJSONObject());
            jsonObject.put("items", (Object)this.items.toJSONArray());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return jsonObject;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(1);
        dest.writeSerializable((Serializable)Boolean.valueOf(this.hasError));
        dest.writeSerializable((Serializable)Boolean.valueOf(this.localError));
        dest.writeInt(this.status);
        dest.writeInt(this.totalcount);
        dest.writeString(TextUtils.isEmpty((CharSequence)this.message) ? "" : this.message);
        this.detailinfo.writeToParcel(dest, flags);
        this.items.writeToParcel(dest, flags);
    }
}

