/*
 * Decompiled with CFR 0.152.
 */
package cc.cloudist.acplibrary;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import android.view.View;
import cc.cloudist.acplibrary.ACProgressBaseDialog;
import cc.cloudist.acplibrary.views.CustomView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public final class ACProgressCustom
extends ACProgressBaseDialog {
    private static final int NO_TYPE = -1;
    private static final int RESOURCE_TYPE = 0;
    private static final int FILE_TYPE = 1;
    private Builder mBuilder;
    private CustomView mCustomView;
    private Timer mTimer;
    private int mSpinCount = 0;
    private int mResourceCount;
    private List<Bitmap> mBitmaps;

    private ACProgressCustom(Builder builder) {
        super(builder.mContext);
        this.mBuilder = builder;
        this.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (ACProgressCustom.this.mTimer != null) {
                    ACProgressCustom.this.mTimer.cancel();
                    ACProgressCustom.this.mTimer = null;
                }
                if (ACProgressCustom.this.mBitmaps != null) {
                    ACProgressCustom.this.mBitmaps.clear();
                    ACProgressCustom.this.mBitmaps = null;
                }
                ACProgressCustom.this.mSpinCount = 0;
                ACProgressCustom.this.mResourceCount = 0;
                ACProgressCustom.this.mCustomView = null;
            }
        });
    }

    public void show() {
        if (this.mBuilder.mType != -1) {
            if (this.mCustomView == null) {
                this.mBitmaps = new ArrayList<Bitmap>();
                int size = (int)((float)this.getMinimumSideOfScreen(this.mBuilder.mContext) * this.mBuilder.mSizeRatio);
                if (this.mBuilder.mType == 0) {
                    this.mResourceCount = this.mBuilder.mResources.size();
                    for (int i = 0; i < this.mResourceCount; ++i) {
                        this.mBitmaps.add(BitmapFactory.decodeResource((Resources)this.mBuilder.mContext.getResources(), (int)((Integer)this.mBuilder.mResources.get(i))));
                    }
                } else {
                    this.mResourceCount = this.mBuilder.mFilePaths.size();
                    for (int i = 0; i < this.mResourceCount; ++i) {
                        this.mBitmaps.add(BitmapFactory.decodeFile((String)((String)this.mBuilder.mFilePaths.get(i))));
                    }
                }
                this.mCustomView = new CustomView(this.mBuilder.mContext, size, this.mBitmaps);
            }
            super.setContentView((View)this.mCustomView);
            super.show();
            long delay = (long)(1000.0f / this.mBuilder.mSpeed);
            this.mTimer = new Timer();
            this.mTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    int result = ACProgressCustom.this.mSpinCount % ACProgressCustom.this.mResourceCount;
                    ACProgressCustom.this.mCustomView.updateIndex(result);
                    if (result == 0) {
                        ACProgressCustom.this.mSpinCount = 1;
                    } else {
                        ACProgressCustom.this.mSpinCount++;
                    }
                }
            }, delay, delay);
        } else {
            Log.d((String)ACProgressCustom.class.toString(), (String)"you must assign the image source in Builder");
        }
    }

    public static class Builder {
        private Context mContext;
        private float mSizeRatio = 0.2f;
        private List<Integer> mResources = new ArrayList<Integer>();
        private List<String> mFilePaths = new ArrayList<String>();
        private int mType = -1;
        private float mSpeed = 6.67f;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder sizeRatio(float ratio) {
            this.mSizeRatio = ratio;
            return this;
        }

        public Builder speed(float speed) {
            this.mSpeed = speed;
            return this;
        }

        public Builder useImages(Integer ... imageIds) {
            if (imageIds != null && imageIds.length != 0) {
                this.mResources.clear();
                Collections.addAll(this.mResources, imageIds);
                this.mType = 0;
            }
            return this;
        }

        public Builder useFiles(String ... paths) {
            if (paths != null && paths.length != 0) {
                this.mFilePaths.clear();
                Collections.addAll(this.mFilePaths, paths);
                this.mType = 1;
            }
            return this;
        }

        public ACProgressCustom build() {
            return new ACProgressCustom(this);
        }
    }
}

