/*
 * Decompiled with CFR 0.152.
 */
package cc.cloudist.acplibrary.views;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import cc.cloudist.acplibrary.components.FlowerDataCalc;
import cc.cloudist.acplibrary.components.PetalCoordinate;
import java.lang.ref.WeakReference;
import java.util.List;

public final class FlowerView
extends View {
    private int mSize;
    private int mFinalSize;
    private int mPetalCount;
    private float mBackgroundCornerRadius;
    private RectF mBackgroundRect;
    private Paint mBackgroundPaint;
    private Paint mPetalPaint;
    private Paint mTextPaint;
    private List<PetalCoordinate> mPetalCoordinates;
    private int[] mPetalColors;
    private Handler mHandler = new FlowerUpdateHandler(this);
    private int mCurrentFocusIndex;
    private String mText;
    private int mTextHeight;
    private int mTextWidth;
    private int mTextMarginTop;
    private boolean mIsExpandWidth;

    public FlowerView(Context context, int size, int bgColor, float bgAlpha, float bgCornerRadius, int petalThickness, int petalCount, float petalAlpha, float borderPadding, float centerPadding, int themeColor, int fadeColor, String text, float textSize, int textColor, float textAlpha, int textMarginTop, boolean textExpandWidth) {
        super(context);
        this.mTextMarginTop = textMarginTop;
        this.init(size, bgColor, bgAlpha, bgCornerRadius, petalThickness, petalCount, petalAlpha, borderPadding, centerPadding, themeColor, fadeColor, text, textSize, textColor, textAlpha, textExpandWidth);
    }

    private void init(int size, int bgColor, float bgAlpha, float bgCornerRadius, int petalThickness, int petalCount, float petalAlpha, float borderPadding, float centerPadding, int themeColor, int fadeColor, String text, float textSize, int textColor, float textAlpha, boolean textExpandWidth) {
        this.mIsExpandWidth = text != null && text.length() != 0 && textExpandWidth;
        this.mSize = size;
        this.mPetalCount = petalCount;
        this.mBackgroundCornerRadius = bgCornerRadius;
        this.mBackgroundPaint = new Paint();
        this.mBackgroundPaint.setAntiAlias(true);
        this.mBackgroundPaint.setColor(bgColor);
        this.mBackgroundPaint.setAlpha((int)(bgAlpha * 255.0f));
        this.mPetalPaint = new Paint();
        this.mPetalPaint.setAntiAlias(true);
        this.mPetalPaint.setStrokeWidth((float)petalThickness);
        this.mPetalPaint.setStrokeCap(Paint.Cap.ROUND);
        if (text != null && text.length() != 0) {
            this.mText = text;
            this.mTextPaint = new Paint();
            this.mTextPaint.setAntiAlias(true);
            this.mTextPaint.setColor(textColor);
            this.mTextPaint.setAlpha((int)(textAlpha * 255.0f));
            this.mTextPaint.setTextSize(textSize);
            Rect textMeasure = new Rect();
            this.mTextPaint.getTextBounds(text, 0, text.length(), textMeasure);
            this.mTextHeight = textMeasure.bottom - textMeasure.top;
            this.mTextWidth = textMeasure.right - textMeasure.left;
        } else {
            this.mTextMarginTop = 0;
        }
        if (this.mIsExpandWidth) {
            this.mBackgroundRect = new RectF(0.0f, 0.0f, (float)(this.mSize + this.mTextHeight + this.mTextMarginTop), (float)(this.mSize + this.mTextHeight + this.mTextMarginTop));
            this.mFinalSize = this.mSize + this.mTextHeight + this.mTextMarginTop;
        } else {
            this.mBackgroundRect = new RectF(0.0f, 0.0f, (float)this.mSize, (float)(this.mSize + this.mTextHeight + this.mTextMarginTop));
            this.mFinalSize = this.mSize;
        }
        FlowerDataCalc calc = new FlowerDataCalc(petalCount);
        this.mPetalCoordinates = calc.getSegmentsCoordinates(this.mSize, (int)(borderPadding * (float)this.mSize), (int)(centerPadding * (float)this.mSize), petalCount, this.mFinalSize);
        this.mPetalColors = calc.getSegmentsColors(themeColor, fadeColor, petalCount, (int)(petalAlpha * 255.0f));
    }

    public void updateFocusIndex(int index) {
        this.mCurrentFocusIndex = index;
        this.mHandler.sendEmptyMessage(0);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mIsExpandWidth) {
            this.setMeasuredDimension(this.mSize + this.mTextHeight + this.mTextMarginTop, this.mSize + this.mTextHeight + this.mTextMarginTop);
        } else {
            this.setMeasuredDimension(this.mSize, this.mSize + this.mTextHeight + this.mTextMarginTop);
        }
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawRoundRect(this.mBackgroundRect, this.mBackgroundCornerRadius, this.mBackgroundCornerRadius, this.mBackgroundPaint);
        for (int i = 0; i < this.mPetalCount; ++i) {
            PetalCoordinate coordinate = this.mPetalCoordinates.get(i);
            int index = (this.mCurrentFocusIndex + i) % this.mPetalCount;
            this.mPetalPaint.setColor(this.mPetalColors[index]);
            canvas.drawLine((float)coordinate.getStartX(), (float)coordinate.getStartY(), (float)coordinate.getEndX(), (float)coordinate.getEndY(), this.mPetalPaint);
        }
        if (this.mText != null) {
            canvas.drawText(this.mText, (float)(this.mFinalSize / 2 - this.mTextWidth / 2), (float)this.mSize, this.mTextPaint);
        }
    }

    private static class FlowerUpdateHandler
    extends Handler {
        WeakReference<FlowerView> reference;

        public FlowerUpdateHandler(FlowerView flowerView) {
            this.reference = new WeakReference<FlowerView>(flowerView);
        }

        public void handleMessage(Message message) {
            FlowerView flowerView = (FlowerView)((Object)this.reference.get());
            if (flowerView != null) {
                flowerView.invalidate();
            }
        }
    }
}

