/*
 * Decompiled with CFR 0.152.
 */
package cc.cloudist.acplibrary.views;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import java.lang.ref.WeakReference;
import java.util.List;

public class CustomView
extends View {
    private int mSize;
    private List<Bitmap> mBitmaps;
    private RectF mRect;
    private int mCurrentIndex = 0;
    private Handler mHandler = new CustomUpdateHandler(this);

    public CustomView(Context context, int size, List<Bitmap> bitmaps) {
        super(context);
        this.mSize = size;
        this.mRect = new RectF(0.0f, 0.0f, (float)size, (float)size);
        this.mBitmaps = bitmaps;
    }

    public void updateIndex(int index) {
        this.mCurrentIndex = index;
        this.mHandler.sendEmptyMessage(0);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.mSize, this.mSize);
    }

    protected void onDraw(Canvas canvas) {
        Log.d((String)"23232", (String)"draw");
        canvas.drawBitmap(this.mBitmaps.get(this.mCurrentIndex), null, this.mRect, null);
    }

    private static class CustomUpdateHandler
    extends Handler {
        WeakReference<CustomView> reference;

        public CustomUpdateHandler(CustomView customView) {
            this.reference = new WeakReference<CustomView>(customView);
        }

        public void handleMessage(Message message) {
            CustomView customView = (CustomView)((Object)this.reference.get());
            if (customView != null) {
                customView.invalidate();
            }
        }
    }
}

