/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.JdbcUtils;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableColumnTask;
import ca.uhn.fhir.jpa.migrate.taskdef.DropForeignKeyTask;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.intellij.lang.annotations.Language;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropColumnTask
extends BaseTableColumnTask {
    private static final Logger ourLog = LoggerFactory.getLogger(DropColumnTask.class);

    public DropColumnTask(String theProductVersion, String theSchemaVersion) {
        super(theProductVersion, theSchemaVersion);
    }

    @Language(value="SQL")
    static String createSql(String theTableName, String theColumnName) {
        return "alter table " + theTableName + " drop column " + theColumnName;
    }

    @Override
    public void validate() {
        super.validate();
        this.setDescription("Drop column " + this.getColumnName() + " from table " + this.getTableName());
    }

    @Override
    public void doExecute() throws SQLException {
        Set<String> columnNames = JdbcUtils.getColumnNames(this.getConnectionProperties(), this.getTableName());
        if (!columnNames.contains(this.getColumnName())) {
            this.logInfo(ourLog, "Column {} does not exist on table {} - No action performed", this.getColumnName(), this.getTableName());
            return;
        }
        if (this.getDriverType().equals((Object)DriverTypeEnum.MYSQL_5_7) || this.getDriverType().equals((Object)DriverTypeEnum.MARIADB_10_1) || this.getDriverType().equals((Object)DriverTypeEnum.MSSQL_2012)) {
            this.logInfo(ourLog, "Dropping any foreign keys on table {} depending on column {}", this.getTableName(), this.getColumnName());
            Set<String> foreignKeys = JdbcUtils.getForeignKeysForColumn(this.getConnectionProperties(), this.getColumnName(), this.getTableName());
            if (foreignKeys != null) {
                for (String foreignKey : foreignKeys) {
                    List<String> dropFkSqls = DropForeignKeyTask.generateSql(this.getTableName(), foreignKey, this.getDriverType());
                    for (String dropFkSql : dropFkSqls) {
                        this.executeSql(this.getTableName(), dropFkSql, new Object[0]);
                    }
                }
            }
        }
        String tableName = this.getTableName();
        String columnName = this.getColumnName();
        String sql = DropColumnTask.createSql(tableName, columnName);
        this.logInfo(ourLog, "Dropping column {} on table {}", this.getColumnName(), this.getTableName());
        this.executeSql(this.getTableName(), sql, new Object[0]);
    }
}

