/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.FlywayMigrator;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.migration.Context;
import org.flywaydb.core.api.migration.JavaMigration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlywayMigrationTask
implements JavaMigration {
    private static final Logger ourLog = LoggerFactory.getLogger(FlywayMigrationTask.class);
    private final BaseTask myTask;
    private final FlywayMigrator myFlywayMigrator;
    private DriverTypeEnum.ConnectionProperties myConnectionProperties;

    public FlywayMigrationTask(BaseTask theTask, FlywayMigrator theFlywayMigrator) {
        this.myTask = theTask;
        this.myFlywayMigrator = theFlywayMigrator;
    }

    public MigrationVersion getVersion() {
        return MigrationVersion.fromVersion((String)this.myTask.getFlywayVersion());
    }

    public String getDescription() {
        return this.myTask.getDescription();
    }

    public Integer getChecksum() {
        return this.myTask.hashCode();
    }

    public boolean isUndo() {
        return false;
    }

    public boolean isBaselineMigration() {
        return false;
    }

    public boolean canExecuteInTransaction() {
        return false;
    }

    public void migrate(Context theContext) {
        this.myTask.setDriverType(this.myFlywayMigrator.getDriverType());
        this.myTask.setDryRun(this.myFlywayMigrator.isDryRun());
        this.myTask.setNoColumnShrink(this.myFlywayMigrator.isNoColumnShrink());
        this.myTask.setConnectionProperties(this.myConnectionProperties);
        try {
            this.executeTask();
        }
        catch (SQLException e) {
            String description = this.myTask.getDescription();
            if (StringUtils.isBlank((CharSequence)description)) {
                description = this.myTask.getClass().getSimpleName();
            }
            String prefix = "Failure executing task \"" + description + "\", aborting! Cause: ";
            throw new InternalErrorException(Msg.code((int)47) + prefix + e.toString(), (Throwable)e);
        }
    }

    private void executeTask() throws SQLException {
        if (this.myFlywayMigrator.isSchemaWasInitialized() && !this.myTask.isRunDuringSchemaInitialization()) {
            this.myTask.setDoNothing(true);
        }
        this.myTask.execute();
        if (this.myTask.initializedSchema()) {
            ourLog.info("Empty schema was Initialized.  Stubbing out all following migration tasks that are not Schema Initializations.");
            this.myFlywayMigrator.setSchemaWasInitialized(true);
        }
        this.myFlywayMigrator.addExecutedStatements(this.myTask.getExecutedStatements());
    }

    public void setConnectionProperties(DriverTypeEnum.ConnectionProperties theConnectionProperties) {
        this.myConnectionProperties = theConnectionProperties;
    }
}

