/*
 * Decompiled with CFR 0.152.
 */
package ca.mimic.oauth2library;

import ca.mimic.oauth2library.OAuthError;
import ca.mimic.oauth2library.Token;
import ca.mimic.oauth2library.Utils;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import okhttp3.Response;

public class OAuthResponse {
    private Response response;
    private String responseBody;
    private Token token;
    private OAuthError error;
    private boolean jsonParsed;
    private Long expiresAt;

    protected OAuthResponse(Response response) throws IOException {
        this.response = response;
        if (response != null) {
            this.responseBody = response.body().string();
            if (Utils.isJsonResponse(response)) {
                Moshi moshi = new Moshi.Builder().build();
                if (response.isSuccessful()) {
                    this.token = (Token)moshi.adapter(Token.class).fromJson(this.responseBody);
                    this.jsonParsed = true;
                    if (this.token.expires_in != null) {
                        this.expiresAt = this.token.expires_in * 1000L + System.currentTimeMillis();
                    }
                } else {
                    try {
                        this.error = (OAuthError)moshi.adapter(OAuthError.class).fromJson(this.responseBody);
                        this.jsonParsed = true;
                    }
                    catch (Exception e) {
                        this.error = new OAuthError(e);
                        this.jsonParsed = false;
                    }
                }
            }
        }
    }

    protected OAuthResponse(Exception e) {
        this.response = null;
        this.error = new OAuthError(e);
    }

    public boolean isSuccessful() {
        return this.response != null && this.response.isSuccessful() && this.jsonParsed;
    }

    public boolean isJsonResponse() {
        return this.jsonParsed;
    }

    public Integer getCode() {
        return this.response != null ? Integer.valueOf(this.response.code()) : null;
    }

    public Long getExpiresIn() {
        return this.token != null ? this.token.expires_in : null;
    }

    public Long getExpiresAt() {
        return this.expiresAt;
    }

    public String getTokenType() {
        return this.token != null ? this.token.token_type : null;
    }

    public String getRefreshToken() {
        return this.token != null ? this.token.refresh_token : null;
    }

    public String getAccessToken() {
        return this.token != null ? this.token.access_token : null;
    }

    public String getScope() {
        return this.token != null ? this.token.scope : null;
    }

    public String getBody() {
        return this.responseBody;
    }

    public OAuthError getOAuthError() {
        return this.error;
    }

    public Response getHttpResponse() {
        return this.response;
    }
}

