/*
 * Decompiled with CFR 0.152.
 */
package ca.mimic.oauth2library;

import ca.mimic.oauth2library.OAuthError;
import ca.mimic.oauth2library.Token;
import ca.mimic.oauth2library.Utils;
import com.google.gson.Gson;
import java.io.IOException;
import okhttp3.Response;

public class OAuthResponse {
    private Response response;
    private String responseBody;
    private Token token;
    private OAuthError error;
    private boolean jsonParsed;
    private Long expiresAt;

    protected OAuthResponse(Response response) throws IOException {
        this.response = response;
        if (response != null) {
            this.responseBody = response.body().string();
            if (Utils.isJsonResponse(response)) {
                if (response.isSuccessful()) {
                    this.token = (Token)new Gson().fromJson(this.responseBody, Token.class);
                    if (this.token.expires_in != null) {
                        this.expiresAt = this.token.expires_in * 1000L + System.currentTimeMillis();
                    }
                } else {
                    this.error = (OAuthError)new Gson().fromJson(this.responseBody, OAuthError.class);
                }
                this.jsonParsed = true;
            }
        }
    }

    public boolean isSuccessful() {
        return this.response != null && this.response.isSuccessful() && this.jsonParsed;
    }

    public boolean isJsonResponse() {
        return this.jsonParsed;
    }

    public Integer getCode() {
        return this.response != null ? Integer.valueOf(this.response.code()) : null;
    }

    public Long getExpiresIn() {
        return this.token != null ? this.token.expires_in : null;
    }

    public Long getExpiresAt() {
        return this.expiresAt;
    }

    public String getTokenType() {
        return this.token != null ? this.token.token_type : null;
    }

    public String getRefreshToken() {
        return this.token != null ? this.token.refresh_token : null;
    }

    public String getAccessToken() {
        return this.token != null ? this.token.access_token : null;
    }

    public String getScope() {
        return this.token != null ? this.token.scope : null;
    }

    public String getBody() {
        return this.responseBody;
    }

    public OAuthError getOAuthError() {
        return this.error;
    }

    public Response getHttpResponse() {
        return this.response;
    }
}

