/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.query.simple;

import builders.dsl.spreadsheet.api.Cell;
import builders.dsl.spreadsheet.api.Row;
import builders.dsl.spreadsheet.api.Sheet;
import builders.dsl.spreadsheet.api.Workbook;
import builders.dsl.spreadsheet.query.api.AbstractSpreadsheetCriteriaResult;
import builders.dsl.spreadsheet.query.api.WorkbookCriterion;
import builders.dsl.spreadsheet.query.simple.SimpleRowCriterion;
import builders.dsl.spreadsheet.query.simple.SimpleSheetCriterion;
import builders.dsl.spreadsheet.query.simple.SimpleWorkbookCriterion;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.function.Consumer;

final class SimpleSpreadsheetCriteriaResult
extends AbstractSpreadsheetCriteriaResult {
    private final Workbook workbook;
    private final Consumer<WorkbookCriterion> workbookCriterion;
    private final int max;

    SimpleSpreadsheetCriteriaResult(Workbook workbook, Consumer<WorkbookCriterion> workbookCriterion, int max) {
        this.workbook = workbook;
        this.workbookCriterion = workbookCriterion;
        this.max = max;
    }

    private Collection<Cell> getCellsInternal(int currentMax) {
        LinkedHashSet<Cell> cells = new LinkedHashSet<Cell>();
        SimpleWorkbookCriterion criterion = new SimpleWorkbookCriterion();
        this.workbookCriterion.accept(criterion);
        for (Sheet sheet : this.workbook.getSheets()) {
            if (!criterion.test(sheet)) continue;
            for (Row row : sheet.getRows()) {
                if (criterion.getCriteria().isEmpty()) {
                    cells.addAll(row.getCells());
                    if (cells.size() < currentMax) continue;
                    return cells;
                }
                for (SimpleSheetCriterion sheetCriterion : criterion.getCriteria()) {
                    if (!sheetCriterion.test(row)) continue;
                    if (sheetCriterion.getCriteria().isEmpty()) {
                        cells.addAll(row.getCells());
                        if (cells.size() < currentMax) continue;
                        return cells;
                    }
                    for (Cell cell : row.getCells()) {
                        for (SimpleRowCriterion rowCriterion : sheetCriterion.getCriteria()) {
                            if (!rowCriterion.test(cell)) continue;
                            cells.add(cell);
                            if (cells.size() < currentMax) continue;
                            return cells;
                        }
                    }
                }
            }
        }
        return cells;
    }

    private Collection<Row> getRowsInternal(int currentMax) {
        LinkedHashSet<Row> rows = new LinkedHashSet<Row>();
        SimpleWorkbookCriterion criterion = new SimpleWorkbookCriterion();
        this.workbookCriterion.accept(criterion);
        for (Sheet sheet : this.workbook.getSheets()) {
            if (!criterion.test(sheet)) continue;
            block1: for (Row row : sheet.getRows()) {
                if (criterion.getCriteria().isEmpty()) {
                    rows.add(row);
                    if (rows.size() < currentMax) continue;
                    return rows;
                }
                for (SimpleSheetCriterion sheetCriterion : criterion.getCriteria()) {
                    if (!sheetCriterion.test(row)) continue;
                    if (sheetCriterion.getCriteria().isEmpty()) {
                        rows.add(row);
                        if (rows.size() < currentMax) continue;
                        return rows;
                    }
                    for (Cell cell : row.getCells()) {
                        for (SimpleRowCriterion rowCriterion : sheetCriterion.getCriteria()) {
                            if (!rowCriterion.test(cell)) continue;
                            rows.add(row);
                            if (rows.size() < currentMax) continue block1;
                            return rows;
                        }
                    }
                }
            }
        }
        return rows;
    }

    private Collection<Sheet> getSheetsInternal(int currentMax) {
        LinkedHashSet<Sheet> sheets = new LinkedHashSet<Sheet>();
        SimpleWorkbookCriterion criterion = new SimpleWorkbookCriterion();
        this.workbookCriterion.accept(criterion);
        block0: for (Sheet sheet : this.workbook.getSheets()) {
            if (!criterion.test(sheet)) continue;
            if (sheet.getRows().isEmpty()) {
                sheets.add(sheet);
                if (sheets.size() < currentMax) continue;
                return sheets;
            }
            for (Row row : sheet.getRows()) {
                if (criterion.getCriteria().isEmpty()) {
                    sheets.add(sheet);
                    if (sheets.size() < currentMax) continue;
                    return sheets;
                }
                for (SimpleSheetCriterion sheetCriterion : criterion.getCriteria()) {
                    if (!sheetCriterion.test(row)) continue;
                    if (sheetCriterion.getCriteria().isEmpty()) {
                        sheets.add(sheet);
                        if (sheets.size() < currentMax) continue;
                        return sheets;
                    }
                    for (Cell cell : row.getCells()) {
                        for (SimpleRowCriterion rowCriterion : sheetCriterion.getCriteria()) {
                            if (!rowCriterion.test(cell)) continue;
                            sheets.add(sheet);
                            if (sheets.size() < currentMax) continue block0;
                            return sheets;
                        }
                    }
                }
            }
        }
        return sheets;
    }

    @Override
    public Collection<Cell> getCells() {
        return this.getCellsInternal(this.max);
    }

    @Override
    public Collection<Row> getRows() {
        return this.getRowsInternal(this.max);
    }

    @Override
    public Collection<Sheet> getSheets() {
        return this.getSheetsInternal(this.max);
    }

    @Override
    public Cell getCell() {
        Collection<Cell> cells = this.getCellsInternal(1);
        if (cells.size() > 0) {
            return cells.iterator().next();
        }
        return null;
    }

    @Override
    public Row getRow() {
        Collection<Row> rows = this.getRowsInternal(1);
        if (rows.size() > 0) {
            return rows.iterator().next();
        }
        return null;
    }

    @Override
    public Sheet getSheet() {
        Collection<Sheet> sheets = this.getSheetsInternal(1);
        if (sheets.size() > 0) {
            return sheets.iterator().next();
        }
        return null;
    }
}

