/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.query.simple;

import builders.dsl.spreadsheet.api.CellStyle;
import builders.dsl.spreadsheet.api.Color;
import builders.dsl.spreadsheet.api.ForegroundFill;
import builders.dsl.spreadsheet.api.Keywords;
import builders.dsl.spreadsheet.query.api.BorderCriterion;
import builders.dsl.spreadsheet.query.api.CellStyleCriterion;
import builders.dsl.spreadsheet.query.api.FontCriterion;
import builders.dsl.spreadsheet.query.simple.SimpleBorderCriterion;
import builders.dsl.spreadsheet.query.simple.SimpleCellCriterion;
import builders.dsl.spreadsheet.query.simple.SimpleFontCriterion;
import java.util.function.Consumer;
import java.util.function.Predicate;

final class SimpleCellStyleCriterion
implements CellStyleCriterion {
    private final SimpleCellCriterion parent;

    SimpleCellStyleCriterion(SimpleCellCriterion parent) {
        this.parent = parent;
    }

    @Override
    public SimpleCellStyleCriterion background(String hexColor) {
        this.parent.addCondition(o -> o.getStyle() != null && new Color(hexColor).equals(o.getStyle().getBackground()));
        return this;
    }

    @Override
    public SimpleCellStyleCriterion background(Color color) {
        this.parent.addCondition(o -> o.getStyle() != null && color.equals(o.getStyle().getBackground()));
        return this;
    }

    @Override
    public SimpleCellStyleCriterion background(Predicate<Color> predicate) {
        this.parent.addCondition(o -> o.getStyle() != null && predicate.test(o.getStyle().getBackground()));
        return this;
    }

    @Override
    public SimpleCellStyleCriterion foreground(String hexColor) {
        this.parent.addCondition(o -> o.getStyle() != null && new Color(hexColor).equals(o.getStyle().getForeground()));
        return this;
    }

    @Override
    public SimpleCellStyleCriterion foreground(Color color) {
        this.parent.addCondition(o -> o.getStyle() != null && color.equals(o.getStyle().getForeground()));
        return this;
    }

    @Override
    public SimpleCellStyleCriterion foreground(Predicate<Color> predicate) {
        this.parent.addCondition(o -> o.getStyle() != null && predicate.test(o.getStyle().getForeground()));
        return this;
    }

    @Override
    public SimpleCellStyleCriterion fill(ForegroundFill fill) {
        this.parent.addCondition(o -> o.getStyle() != null && fill.equals((Object)o.getStyle().getFill()));
        return this;
    }

    @Override
    public SimpleCellStyleCriterion fill(Predicate<ForegroundFill> predicate) {
        this.parent.addCondition(o -> o.getStyle() != null && predicate.test(o.getStyle().getFill()));
        return this;
    }

    @Override
    public SimpleCellStyleCriterion indent(int indent) {
        this.parent.addCondition(o -> o.getStyle() != null && indent == o.getStyle().getIndent());
        return this;
    }

    @Override
    public SimpleCellStyleCriterion indent(Predicate<Integer> predicate) {
        this.parent.addCondition(o -> o.getStyle() != null && predicate.test(o.getStyle().getIndent()));
        return this;
    }

    @Override
    public SimpleCellStyleCriterion rotation(int rotation) {
        this.parent.addCondition(o -> o.getStyle() != null && rotation == o.getStyle().getRotation());
        return this;
    }

    @Override
    public SimpleCellStyleCriterion rotation(Predicate<Integer> predicate) {
        this.parent.addCondition(o -> o.getStyle() != null && predicate.test(o.getStyle().getRotation()));
        return this;
    }

    @Override
    public SimpleCellStyleCriterion format(String format) {
        this.parent.addCondition(o -> o.getStyle() != null && format.equals(o.getStyle().getFormat()));
        return this;
    }

    @Override
    public SimpleCellStyleCriterion format(Predicate<String> format) {
        this.parent.addCondition(o -> o.getStyle() != null && format.test(o.getStyle().getFormat()));
        return this;
    }

    @Override
    public SimpleCellStyleCriterion font(Consumer<FontCriterion> fontCriterion) {
        SimpleFontCriterion simpleFontCriterion = new SimpleFontCriterion(this.parent);
        fontCriterion.accept(simpleFontCriterion);
        return this;
    }

    @Override
    public SimpleCellStyleCriterion border(Consumer<BorderCriterion> borderConfiguration) {
        this.border(Keywords.BorderSide.BORDER_SIDES, borderConfiguration);
        return this;
    }

    @Override
    public SimpleCellStyleCriterion border(Keywords.BorderSide location, Consumer<BorderCriterion> borderConfiguration) {
        this.border(new Keywords.BorderSide[]{location}, borderConfiguration);
        return this;
    }

    @Override
    public SimpleCellStyleCriterion border(Keywords.BorderSide first, Keywords.BorderSide second, Consumer<BorderCriterion> borderConfiguration) {
        this.border(new Keywords.BorderSide[]{first, second}, borderConfiguration);
        return this;
    }

    @Override
    public SimpleCellStyleCriterion border(Keywords.BorderSide first, Keywords.BorderSide second, Keywords.BorderSide third, Consumer<BorderCriterion> borderConfiguration) {
        this.border(new Keywords.BorderSide[]{first, second, third}, borderConfiguration);
        return this;
    }

    @Override
    public CellStyleCriterion having(Predicate<CellStyle> cellStylePredicate) {
        this.parent.addCondition(o -> o.getStyle() != null && cellStylePredicate.test(o.getStyle()));
        return this;
    }

    private void border(Keywords.BorderSide[] sides, Consumer<BorderCriterion> borderConfiguration) {
        for (Keywords.BorderSide side : sides) {
            SimpleBorderCriterion criterion = new SimpleBorderCriterion(this.parent, side);
            borderConfiguration.accept(criterion);
        }
    }
}

