/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.query.simple;

import builders.dsl.spreadsheet.api.Cell;
import builders.dsl.spreadsheet.api.Comment;
import builders.dsl.spreadsheet.query.api.CellCriterion;
import builders.dsl.spreadsheet.query.api.CellStyleCriterion;
import builders.dsl.spreadsheet.query.simple.AbstractCriterion;
import builders.dsl.spreadsheet.query.simple.SimpleCellStyleCriterion;
import java.util.Calendar;
import java.util.Date;
import java.util.function.Consumer;
import java.util.function.Predicate;

final class SimpleCellCriterion
extends AbstractCriterion<Cell, CellCriterion>
implements CellCriterion {
    SimpleCellCriterion() {
    }

    private SimpleCellCriterion(boolean disjoint) {
        super(disjoint);
    }

    @Override
    public SimpleCellCriterion date(Date value) {
        this.addValueCondition(value, Date.class);
        return this;
    }

    @Override
    public SimpleCellCriterion date(Predicate<Date> predicate) {
        this.addValueCondition(predicate, Date.class);
        return this;
    }

    @Override
    public SimpleCellCriterion number(Double value) {
        this.addValueCondition(value, Double.class);
        return this;
    }

    @Override
    public SimpleCellCriterion number(Predicate<Double> predicate) {
        this.addValueCondition(predicate, Double.class);
        return this;
    }

    @Override
    public SimpleCellCriterion string(String value) {
        this.addValueCondition(value, String.class);
        return this;
    }

    @Override
    public SimpleCellCriterion string(Predicate<String> predicate) {
        this.addValueCondition(predicate, String.class);
        return this;
    }

    @Override
    public SimpleCellCriterion value(Object value) {
        if (value == null) {
            this.string("");
            return this;
        }
        if (value instanceof Date) {
            this.date((Date)value);
            return this;
        }
        if (value instanceof Calendar) {
            this.date(((Calendar)value).getTime());
            return this;
        }
        if (value instanceof Number) {
            this.number(((Number)value).doubleValue());
            return this;
        }
        if (value instanceof Boolean) {
            this.bool((Boolean)value);
        }
        this.string(value.toString());
        return this;
    }

    @Override
    public SimpleCellCriterion name(String name) {
        this.addCondition(o -> name.equals(o.getName()));
        return this;
    }

    @Override
    public SimpleCellCriterion comment(String comment) {
        this.addCondition(o -> comment.equals(o.getComment().getText()));
        return this;
    }

    @Override
    public SimpleCellCriterion bool(Boolean value) {
        this.addValueCondition(value, Boolean.class);
        return this;
    }

    @Override
    public SimpleCellCriterion style(Consumer<CellStyleCriterion> styleCriterion) {
        SimpleCellStyleCriterion criterion = new SimpleCellStyleCriterion(this);
        styleCriterion.accept(criterion);
        return this;
    }

    @Override
    public SimpleCellCriterion rowspan(int span) {
        this.addCondition(o -> span == o.getRowspan());
        return this;
    }

    @Override
    public SimpleCellCriterion rowspan(Predicate<Integer> predicate) {
        this.addCondition(o -> predicate.test(o.getRowspan()));
        return this;
    }

    @Override
    public SimpleCellCriterion colspan(int span) {
        this.addCondition(o -> span == o.getColspan());
        return this;
    }

    @Override
    public SimpleCellCriterion colspan(Predicate<Integer> predicate) {
        this.addCondition(o -> predicate.test(o.getColspan()));
        return this;
    }

    @Override
    public SimpleCellCriterion name(Predicate<String> predicate) {
        this.addCondition(o -> predicate.test(o.getName()));
        return this;
    }

    @Override
    public SimpleCellCriterion comment(Predicate<Comment> predicate) {
        this.addCondition(o -> predicate.test(o.getComment()));
        return this;
    }

    private <T> void addValueCondition(T value, Class<T> type) {
        this.addCondition(o -> {
            try {
                return value.equals(o.read(type));
            }
            catch (Exception e) {
                return false;
            }
        });
    }

    private <T> void addValueCondition(Predicate<T> predicate, Class<T> type) {
        this.addCondition(o -> {
            try {
                return predicate.test(o.read(type));
            }
            catch (Exception e) {
                return false;
            }
        });
    }

    @Override
    public SimpleCellCriterion or(Consumer<CellCriterion> sheetCriterion) {
        return (SimpleCellCriterion)super.or(sheetCriterion);
    }

    @Override
    public CellCriterion having(Predicate<Cell> cellPredicate) {
        this.addCondition(cellPredicate);
        return this;
    }

    @Override
    CellCriterion newDisjointCriterionInstance() {
        return new SimpleCellCriterion(true);
    }
}

