/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.query.simple;

import builders.dsl.spreadsheet.api.Border;
import builders.dsl.spreadsheet.api.BorderStyle;
import builders.dsl.spreadsheet.api.CellStyle;
import builders.dsl.spreadsheet.api.Color;
import builders.dsl.spreadsheet.api.Keywords;
import builders.dsl.spreadsheet.query.api.BorderCriterion;
import builders.dsl.spreadsheet.query.simple.SimpleCellCriterion;
import java.util.function.Predicate;

final class SimpleBorderCriterion
implements BorderCriterion {
    private final SimpleCellCriterion parent;
    private final Keywords.BorderSide side;

    SimpleBorderCriterion(SimpleCellCriterion parent, Keywords.BorderSide side) {
        this.parent = parent;
        this.side = side;
    }

    @Override
    public SimpleBorderCriterion style(BorderStyle borderStyle) {
        this.parent.addCondition(o -> {
            CellStyle style = o.getStyle();
            if (style == null) {
                return false;
            }
            Border border = style.getBorder(this.side);
            return border != null && borderStyle.equals((Object)border.getStyle());
        });
        return this;
    }

    @Override
    public SimpleBorderCriterion style(Predicate<BorderStyle> predicate) {
        this.parent.addCondition(o -> {
            CellStyle style = o.getStyle();
            if (style == null) {
                return false;
            }
            Border border = style.getBorder(this.side);
            return border != null && predicate.test(border.getStyle());
        });
        return this;
    }

    @Override
    public SimpleBorderCriterion color(String hexColor) {
        this.color(new Color(hexColor));
        return this;
    }

    @Override
    public SimpleBorderCriterion color(Color color) {
        this.parent.addCondition(o -> {
            CellStyle style = o.getStyle();
            if (style == null) {
                return false;
            }
            Border border = style.getBorder(this.side);
            return border != null && color.equals(border.getColor());
        });
        return this;
    }

    @Override
    public SimpleBorderCriterion color(Predicate<Color> predicate) {
        this.parent.addCondition(o -> {
            CellStyle style = o.getStyle();
            if (style == null) {
                return false;
            }
            Border border = style.getBorder(this.side);
            return border != null && predicate.test(border.getColor());
        });
        return this;
    }

    @Override
    public BorderCriterion having(Predicate<Border> borderPredicate) {
        this.parent.addCondition(o -> {
            CellStyle style = o.getStyle();
            if (style == null) {
                return false;
            }
            Border border = style.getBorder(this.side);
            return border != null && borderPredicate.test(border);
        });
        return this;
    }
}

