/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.query.simple;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

abstract class AbstractCriterion<T, C extends Predicate<T>>
implements Predicate<T> {
    private final List<Predicate<T>> predicates = new ArrayList<Predicate<T>>();
    private final boolean disjoint;

    AbstractCriterion() {
        this(false);
    }

    AbstractCriterion(boolean disjoint) {
        this.disjoint = disjoint;
    }

    @Override
    public boolean test(T o) {
        if (this.disjoint) {
            return this.passesAnyCondition(o);
        }
        return this.passesAllConditions(o);
    }

    abstract C newDisjointCriterionInstance();

    public AbstractCriterion<T, C> or(Consumer<C> sheetCriterion) {
        C criterion = this.newDisjointCriterionInstance();
        sheetCriterion.accept(criterion);
        this.addCondition((Predicate<T>)criterion);
        return this;
    }

    void addCondition(Predicate<T> predicate) {
        this.predicates.add(predicate);
    }

    private boolean passesAnyCondition(T object) {
        if (this.predicates.isEmpty()) {
            return true;
        }
        for (Predicate<T> predicate : this.predicates) {
            if (!predicate.test(object)) continue;
            return true;
        }
        return false;
    }

    private boolean passesAllConditions(T object) {
        if (this.predicates.isEmpty()) {
            return true;
        }
        for (Predicate<T> predicate : this.predicates) {
            if (predicate.test(object)) continue;
            return false;
        }
        return true;
    }
}

