/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.impl;

import builders.dsl.spreadsheet.builder.api.CellDefinition;
import builders.dsl.spreadsheet.builder.api.DimensionModifier;

public class HeightModifier
implements DimensionModifier {
    private double pointsPerCentimeter;
    private double pointsPerInch;
    private final CellDefinition cell;
    private final double height;

    public HeightModifier(CellDefinition cell, double height, double pointsPerCentimeter, double pointsPerInch) {
        this.height = height;
        this.cell = cell;
        this.pointsPerCentimeter = pointsPerCentimeter;
        this.pointsPerInch = pointsPerInch;
    }

    @Override
    public CellDefinition cm() {
        this.cell.height(this.pointsPerCentimeter * this.height);
        return this.cell;
    }

    @Override
    public CellDefinition inch() {
        this.cell.height(this.pointsPerInch * this.height);
        return this.cell;
    }

    @Override
    public CellDefinition inches() {
        return this.inch();
    }

    @Override
    public CellDefinition points() {
        return this.cell;
    }
}

