/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.impl;

import builders.dsl.spreadsheet.builder.api.CellStyleDefinition;
import builders.dsl.spreadsheet.builder.api.Resolvable;
import builders.dsl.spreadsheet.builder.api.SheetDefinition;
import builders.dsl.spreadsheet.builder.api.Stylesheet;
import builders.dsl.spreadsheet.builder.api.WorkbookDefinition;
import builders.dsl.spreadsheet.impl.AbstractCellStyleDefinition;
import builders.dsl.spreadsheet.impl.AbstractPendingFormula;
import builders.dsl.spreadsheet.impl.AbstractPendingLink;
import builders.dsl.spreadsheet.impl.AbstractSheetDefinition;
import builders.dsl.spreadsheet.impl.Utils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public abstract class AbstractWorkbookDefinition
implements WorkbookDefinition {
    private final Map<String, Consumer<CellStyleDefinition>> namedStylesDefinition = new LinkedHashMap<String, Consumer<CellStyleDefinition>>();
    private final Map<String, AbstractCellStyleDefinition> namedStyles = new LinkedHashMap<String, AbstractCellStyleDefinition>();
    private final Map<String, AbstractSheetDefinition> sheets = new LinkedHashMap<String, AbstractSheetDefinition>();
    private final List<Resolvable> toBeResolved = new ArrayList<Resolvable>();

    @Override
    public final WorkbookDefinition style(String name, Consumer<CellStyleDefinition> styleDefinition) {
        this.namedStylesDefinition.put(name, styleDefinition);
        return this;
    }

    @Override
    public final WorkbookDefinition apply(Class<? extends Stylesheet> stylesheet) {
        try {
            this.apply(stylesheet.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return this;
    }

    @Override
    public final WorkbookDefinition apply(Stylesheet stylesheet) {
        stylesheet.declareStyles(this);
        return this;
    }

    public final void resolve() {
        for (Resolvable resolvable : this.toBeResolved) {
            resolvable.resolve();
        }
    }

    protected abstract AbstractCellStyleDefinition createCellStyle();

    protected abstract AbstractSheetDefinition createSheet(String var1);

    @Override
    public final WorkbookDefinition sheet(String name, Consumer<SheetDefinition> sheetDefinition) {
        AbstractSheetDefinition sheet = this.sheets.get(name);
        if (sheet == null) {
            sheet = this.createSheet(name);
            this.sheets.put(name, sheet);
        }
        sheetDefinition.accept(sheet);
        sheet.resolve();
        return this;
    }

    final AbstractCellStyleDefinition getStyles(Iterable<String> names) {
        String name = Utils.join(names, ".");
        AbstractCellStyleDefinition style = this.namedStyles.get(name);
        if (style != null) {
            return style;
        }
        style = this.createCellStyle();
        for (String n : names) {
            this.getStyleDefinition(n).accept(style);
        }
        style.seal();
        this.namedStyles.put(name, style);
        return style;
    }

    final Consumer<CellStyleDefinition> getStyleDefinition(String name) {
        Consumer<CellStyleDefinition> style = this.namedStylesDefinition.get(name);
        if (style == null) {
            throw new IllegalArgumentException("Style '" + name + "' is not defined");
        }
        return style;
    }

    void addPendingFormula(AbstractPendingFormula formula) {
        this.toBeResolved.add(formula);
    }

    protected void addPendingLink(AbstractPendingLink link) {
        this.toBeResolved.add(link);
    }
}

