/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.impl;

import builders.dsl.spreadsheet.builder.api.CellDefinition;
import builders.dsl.spreadsheet.builder.api.CellStyleDefinition;
import builders.dsl.spreadsheet.builder.api.RowDefinition;
import builders.dsl.spreadsheet.impl.AbstractCellDefinition;
import builders.dsl.spreadsheet.impl.AbstractSheetDefinition;
import builders.dsl.spreadsheet.impl.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public abstract class AbstractRowDefinition
implements RowDefinition {
    protected final AbstractSheetDefinition sheet;
    private List<String> styles = new ArrayList<String>();
    private List<Consumer<CellStyleDefinition>> styleDefinitions = new ArrayList<Consumer<CellStyleDefinition>>();
    private final List<Integer> startPositions = new ArrayList<Integer>();
    private int nextColNumber;
    private final Map<Integer, AbstractCellDefinition> cells = new LinkedHashMap<Integer, AbstractCellDefinition>();

    protected AbstractRowDefinition(AbstractSheetDefinition sheet) {
        this.sheet = sheet;
    }

    private AbstractCellDefinition findOrCreateCell(int zeroBasedCellNumber) {
        AbstractCellDefinition cell = this.cells.get(zeroBasedCellNumber + 1);
        if (cell != null) {
            return cell;
        }
        cell = this.createCell(zeroBasedCellNumber);
        this.cells.put(zeroBasedCellNumber + 1, cell);
        return cell;
    }

    protected abstract AbstractCellDefinition createCell(int var1);

    @Override
    public final RowDefinition cell() {
        this.cell((Object)null);
        return this;
    }

    @Override
    public final RowDefinition cell(Object value) {
        AbstractCellDefinition cell = this.findOrCreateCell(this.nextColNumber++);
        if (!this.styles.isEmpty() || !this.styleDefinitions.isEmpty()) {
            cell.styles((Iterable)this.styles, this.styleDefinitions);
        }
        cell.value(value);
        cell.resolve();
        return this;
    }

    @Override
    public final RowDefinition cell(Consumer<CellDefinition> cellDefinition) {
        AbstractCellDefinition poiCell = this.findOrCreateCell(this.nextColNumber);
        if (!this.styles.isEmpty() || !this.styleDefinitions.isEmpty()) {
            poiCell.styles((Iterable)this.styles, this.styleDefinitions);
        }
        cellDefinition.accept(poiCell);
        this.nextColNumber += poiCell.getColspan();
        this.handleSpans(poiCell);
        poiCell.resolve();
        return this;
    }

    protected abstract void handleSpans(AbstractCellDefinition var1);

    @Override
    public final RowDefinition cell(int column, Consumer<CellDefinition> cellDefinition) {
        AbstractCellDefinition poiCell = this.findOrCreateCell(column - 1);
        if (!this.styles.isEmpty() || !this.styleDefinitions.isEmpty()) {
            poiCell.styles((Iterable)this.styles, this.styleDefinitions);
        }
        cellDefinition.accept(poiCell);
        this.nextColNumber = column - 1 + poiCell.getColspan();
        this.handleSpans(poiCell);
        poiCell.resolve();
        return this;
    }

    @Override
    public final RowDefinition cell(String column, Consumer<CellDefinition> cellDefinition) {
        this.cell(Utils.parseColumn(column), cellDefinition);
        return this;
    }

    @Override
    public final RowDefinition style(Consumer<CellStyleDefinition> styleDefinition) {
        this.styleDefinitions.add(styleDefinition);
        return this;
    }

    @Override
    public final RowDefinition style(String name) {
        this.styles.add(name);
        return this;
    }

    @Override
    public final RowDefinition style(String name, Consumer<CellStyleDefinition> styleDefinition) {
        this.style(name);
        this.style((Consumer)styleDefinition);
        return this;
    }

    @Override
    public final RowDefinition styles(Iterable<String> names, Consumer<CellStyleDefinition> styleDefinition) {
        this.styles((Iterable)names);
        this.style((Consumer)styleDefinition);
        return this;
    }

    @Override
    public final RowDefinition styles(Iterable<String> styles, Iterable<Consumer<CellStyleDefinition>> styleDefinitions) {
        this.styles((Iterable)styles);
        for (Consumer<CellStyleDefinition> style : styleDefinitions) {
            this.styleDefinitions.add(style);
        }
        return this;
    }

    @Override
    public final RowDefinition styles(String ... names) {
        this.styles.addAll(Arrays.asList(names));
        return this;
    }

    @Override
    public final RowDefinition styles(Iterable<String> names) {
        for (String name : names) {
            this.styles.add(name);
        }
        return this;
    }

    AbstractSheetDefinition getSheet() {
        return this.sheet;
    }

    @Override
    public final RowDefinition group(Consumer<RowDefinition> insideGroupDefinition) {
        this.createGroup(false, insideGroupDefinition);
        return this;
    }

    @Override
    public final RowDefinition collapse(Consumer<RowDefinition> insideGroupDefinition) {
        this.createGroup(true, insideGroupDefinition);
        return this;
    }

    private void createGroup(boolean collapsed, Consumer<RowDefinition> insideGroupDefinition) {
        this.startPositions.add(this.nextColNumber);
        insideGroupDefinition.accept(this);
        int startPosition = this.startPositions.remove(this.startPositions.size() - 1);
        if (this.nextColNumber - startPosition > 0) {
            int endPosition = this.nextColNumber - 1;
            this.doCreateGroup(startPosition, endPosition, collapsed);
        }
    }

    protected abstract void doCreateGroup(int var1, int var2, boolean var3);

    public String toString() {
        return "Row[" + this.sheet.getName() + "!" + this.getNumber() + "]";
    }

    protected abstract int getNumber();

    List<String> getStyles() {
        return Collections.unmodifiableList(this.styles);
    }
}

