/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.impl;

import builders.dsl.spreadsheet.api.Keywords;
import builders.dsl.spreadsheet.api.Spannable;
import builders.dsl.spreadsheet.builder.api.CellDefinition;
import builders.dsl.spreadsheet.builder.api.CellStyleDefinition;
import builders.dsl.spreadsheet.builder.api.CommentDefinition;
import builders.dsl.spreadsheet.builder.api.FontDefinition;
import builders.dsl.spreadsheet.builder.api.LinkDefinition;
import builders.dsl.spreadsheet.builder.api.Resolvable;
import builders.dsl.spreadsheet.impl.AbstractCellStyleDefinition;
import builders.dsl.spreadsheet.impl.AbstractPendingFormula;
import builders.dsl.spreadsheet.impl.AbstractRowDefinition;
import builders.dsl.spreadsheet.impl.DefaultCommentDefinition;
import builders.dsl.spreadsheet.impl.RichTextPart;
import builders.dsl.spreadsheet.impl.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public abstract class AbstractCellDefinition
implements CellDefinition,
Resolvable,
Spannable {
    private final AbstractRowDefinition row;
    private int colspan = 1;
    private int rowspan = 1;
    protected AbstractCellStyleDefinition cellStyle;
    protected List<RichTextPart> richTextParts = new ArrayList<RichTextPart>();

    protected AbstractCellDefinition(AbstractRowDefinition row) {
        this.row = Objects.requireNonNull(row, "Row");
    }

    @Override
    public final CellDefinition comment(String commentText) {
        this.comment((CommentDefinition commentDefinition) -> commentDefinition.text(commentText));
        return this;
    }

    @Override
    public final CellDefinition formula(String formula) {
        this.row.getSheet().getWorkbook().addPendingFormula(this.createPendingFormula(formula));
        return this;
    }

    protected abstract AbstractPendingFormula createPendingFormula(String var1);

    @Override
    public final CellDefinition comment(Consumer<CommentDefinition> commentDefinition) {
        DefaultCommentDefinition poiComment = new DefaultCommentDefinition();
        commentDefinition.accept(poiComment);
        this.applyComment(poiComment);
        return this;
    }

    @Override
    public final CellDefinition colspan(int span) {
        this.colspan = span;
        return this;
    }

    @Override
    public final CellDefinition rowspan(int span) {
        this.rowspan = span;
        return this;
    }

    @Override
    public final CellDefinition style(String name) {
        return this.styles((Iterable)Collections.singleton(name), (Iterable)Collections.emptyList());
    }

    @Override
    public final CellDefinition styles(String ... names) {
        return this.styles((Iterable)Arrays.asList(names), (Iterable)Collections.emptyList());
    }

    @Override
    public final CellDefinition style(Consumer<CellStyleDefinition> styleDefinition) {
        return this.styles((Iterable)Collections.emptyList(), Collections.singleton(styleDefinition));
    }

    @Override
    public final CellDefinition styles(Iterable<String> names) {
        return this.styles((Iterable)names, (Iterable)Collections.emptyList());
    }

    @Override
    public final CellDefinition style(String name, Consumer<CellStyleDefinition> styleDefinition) {
        return this.styles((Iterable)Collections.singleton(name), Collections.singleton(styleDefinition));
    }

    @Override
    public final CellDefinition styles(Iterable<String> names, Consumer<CellStyleDefinition> styleDefinition) {
        return this.styles((Iterable)names, Collections.singleton(styleDefinition));
    }

    @Override
    public final CellDefinition styles(Iterable<String> names, Iterable<Consumer<CellStyleDefinition>> styleDefinition) {
        if (styleDefinition == null || !styleDefinition.iterator().hasNext()) {
            if (names == null || !names.iterator().hasNext()) {
                return this;
            }
            LinkedHashSet<String> allNames = new LinkedHashSet<String>();
            for (String name : names) {
                allNames.add(name);
            }
            allNames.addAll(this.row.getStyles());
            if (this.cellStyle == null) {
                this.cellStyle = this.row.getSheet().getWorkbook().getStyles(allNames);
                this.assignStyle(this.cellStyle);
                return this;
            }
            if (this.cellStyle.isSealed()) {
                if (!this.row.getStyles().isEmpty()) {
                    this.cellStyle = null;
                    this.styles(allNames);
                    return this;
                }
            } else {
                for (String name : names) {
                    this.row.getSheet().getWorkbook().getStyleDefinition(name).accept(this.cellStyle);
                }
            }
            return this;
        }
        if (this.cellStyle == null) {
            this.cellStyle = this.createCellStyle();
        }
        if (this.cellStyle.isSealed()) {
            throw new IllegalStateException("The cell style '" + Utils.join(names, ".") + "' is already sealed! You need to create new style. Use 'styles' method to combine multiple named styles! Create new named style if you're trying to update existing style with closure definition.");
        }
        for (String string : names) {
            this.row.getSheet().getWorkbook().getStyleDefinition(string).accept(this.cellStyle);
        }
        for (Consumer consumer : styleDefinition) {
            consumer.accept(this.cellStyle);
        }
        return this;
    }

    protected abstract AbstractCellStyleDefinition createCellStyle();

    protected abstract void assignStyle(CellStyleDefinition var1);

    @Override
    public final CellDefinition name(String name) {
        if (!Utils.fixName(name).equals(name)) {
            throw new IllegalArgumentException("Name " + name + " is not valid Excel name! Suggestion: " + Utils.fixName(name));
        }
        this.doName(name);
        return this;
    }

    protected abstract void doName(String var1);

    @Override
    public final LinkDefinition link(Keywords.To to) {
        return this.createLinkDefinition();
    }

    protected abstract LinkDefinition createLinkDefinition();

    @Override
    public final CellDefinition text(String run) {
        this.text(run, null);
        return this;
    }

    @Override
    public final CellDefinition text(String run, Consumer<FontDefinition> fontConfiguration) {
        if (run == null || run.length() == 0) {
            return this;
        }
        int start = 0;
        if (this.richTextParts != null && this.richTextParts.size() > 0) {
            start = this.richTextParts.get(this.richTextParts.size() - 1).getEnd();
        }
        int end = start + run.length();
        if (fontConfiguration == null) {
            this.richTextParts.add(new RichTextPart(run, null, start, end));
            return this;
        }
        FontDefinition font = this.createFontDefinition();
        fontConfiguration.accept(font);
        this.richTextParts.add(new RichTextPart(run, font, start, end));
        return this;
    }

    protected abstract FontDefinition createFontDefinition();

    @Override
    public final int getColspan() {
        return this.colspan;
    }

    @Override
    public final int getRowspan() {
        return this.rowspan;
    }

    protected abstract void applyComment(DefaultCommentDefinition var1);

    public AbstractRowDefinition getRow() {
        return this.row;
    }
}

