/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.api;

import builders.dsl.spreadsheet.api.Cell;
import builders.dsl.spreadsheet.api.Row;
import builders.dsl.spreadsheet.api.Sheet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class DataRow
implements Row {
    private final Row row;
    private final Map<String, Cell> cells;

    public static DataRow create(Row row, Row headersRow) {
        Collection<? extends Cell> cells = headersRow.getCells();
        HashMap<String, Integer> mapping = new HashMap<String, Integer>(cells.size());
        for (Cell cell : cells) {
            mapping.put(String.valueOf(cell.getValue()), cell.getColumn());
        }
        return new DataRow(row, mapping);
    }

    public static DataRow create(Map<String, Integer> mapping, Row row) {
        return new DataRow(row, new HashMap<String, Integer>(mapping));
    }

    private DataRow(Row row, Map<String, Integer> mapping) {
        this.row = row;
        HashMap<String, Cell> cells = new HashMap<String, Cell>(row.getCells().size());
        for (Map.Entry<String, Integer> entry : mapping.entrySet()) {
            for (Cell cell : row.getCells()) {
                if (cell.getColumn() != entry.getValue().intValue()) continue;
                cells.put(entry.getKey(), cell);
            }
        }
        this.cells = cells;
    }

    public Cell get(String name) {
        return this.cells.get(name);
    }

    @Override
    public int getNumber() {
        return this.row.getNumber();
    }

    @Override
    public Sheet getSheet() {
        return this.row.getSheet();
    }

    @Override
    public Collection<? extends Cell> getCells() {
        return this.row.getCells();
    }

    @Override
    public Row getAbove() {
        return this.row.getAbove();
    }

    @Override
    public Row getAbove(int howMany) {
        return this.row.getAbove(howMany);
    }

    @Override
    public Row getBelow() {
        return this.row.getBelow();
    }

    @Override
    public Row getBelow(int howMany) {
        return this.row.getBelow(howMany);
    }
}

