/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview;

import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.Toolbar;
import bg.devlabs.fullscreenvideoview.FullscreenVideoView;
import bg.devlabs.fullscreenvideoview.R;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class VisibilityManager {
    private ArrayList<View> hiddenViews = new ArrayList();

    public void showHiddenViews() {
        int size = this.hiddenViews.size();
        for (int i = 0; i < size; ++i) {
            View view = this.hiddenViews.get(i);
            view.setVisibility(0);
        }
        this.hiddenViews.clear();
    }

    public void hideVisibleViews(ViewGroup parentLayout) {
        List<View> views = this.getVisibleChildViews((View)parentLayout);
        int size = views.size();
        for (int i = 0; i < size; ++i) {
            View view = views.get(i);
            view.setVisibility(8);
            this.hiddenViews.add(view);
        }
    }

    private List<View> getVisibleChildViews(View parentLayout) {
        if (!this.shouldCheckChildren(parentLayout)) {
            return Collections.singletonList(parentLayout);
        }
        int childCount = ((ViewGroup)parentLayout).getChildCount();
        ArrayList<View> children = new ArrayList<View>(childCount);
        for (int i = 0; i < childCount; ++i) {
            View view = ((ViewGroup)parentLayout).getChildAt(i);
            if (this.shouldCheckChildren(view)) {
                children.addAll(this.getVisibleChildViews(view));
                continue;
            }
            if (view instanceof FullscreenVideoView) {
                ImageButton fullscreenButton = (ImageButton)view.findViewById(R.id.fullscreen_media_button);
                String buttonTag = (String)fullscreenButton.getTag();
                if (view.getVisibility() != 0 || Objects.equals(buttonTag, "view_tag:clicked")) continue;
                children.add(view);
                continue;
            }
            if (view.getVisibility() != 0) continue;
            children.add(view);
        }
        return children;
    }

    private boolean shouldCheckChildren(View view) {
        if (Build.VERSION.SDK_INT >= 21) {
            return view instanceof ViewGroup && !(view instanceof android.support.v7.widget.Toolbar) && !(view instanceof Toolbar) && !(view instanceof FullscreenVideoView);
        }
        return view instanceof ViewGroup && !(view instanceof android.support.v7.widget.Toolbar) && !(view instanceof FullscreenVideoView);
    }
}

