/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview;

import android.content.Context;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.WindowManager;

public class DeviceDimensionsManager {
    private static volatile DeviceDimensionsManager INSTANCE;

    private DeviceDimensionsManager() {
        if (INSTANCE != null) {
            throw new RuntimeException("Use getInstance() method to get the single instance of this class.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DeviceDimensionsManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<DeviceDimensionsManager> clazz = DeviceDimensionsManager.class;
        synchronized (DeviceDimensionsManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new DeviceDimensionsManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public int getDisplayWidth(Context context) {
        return this.getDisplayMetrics((Context)context).widthPixels;
    }

    public int getDisplayHeight(Context context) {
        return this.getDisplayMetrics((Context)context).heightPixels;
    }

    public int getRealHeight(Context context) {
        DisplayMetrics realDisplayMetrics = this.getRealDisplayMetrics(context);
        if (realDisplayMetrics == null) {
            return 0;
        }
        return realDisplayMetrics.heightPixels;
    }

    public int getRealWidth(Context context) {
        DisplayMetrics realDisplayMetrics = this.getRealDisplayMetrics(context);
        if (realDisplayMetrics == null) {
            return 0;
        }
        return realDisplayMetrics.widthPixels;
    }

    private DisplayMetrics getRealDisplayMetrics(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (windowManager == null) {
            return null;
        }
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics realMetrics = new DisplayMetrics();
        display.getRealMetrics(realMetrics);
        return realMetrics;
    }

    private DisplayMetrics getDisplayMetrics(Context context) {
        return context.getResources().getDisplayMetrics();
    }

    public static float convertDpToPixel(float dp, Context context) {
        Resources r = context.getResources();
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)r.getDisplayMetrics());
    }

    public static float convertPixelsToDp(float px, Context context) {
        Resources r = context.getResources();
        DisplayMetrics metrics = r.getDisplayMetrics();
        return px / ((float)metrics.densityDpi / 160.0f);
    }
}

