/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.widget.ImageButton;
import android.widget.TextView;
import bg.devlabs.fullscreenvideoview.R;
import bg.devlabs.fullscreenvideoview.VideoMediaPlayer;
import bg.devlabs.fullscreenvideoview.orientation.OrientationHelper;
import java.lang.ref.WeakReference;

class ButtonHelper {
    private Drawable exitFullscreenDrawable;
    private Drawable enterFullscreenDrawable;
    private Drawable playDrawable;
    private Drawable pauseDrawable;
    private Drawable fastForwardDrawable;
    private Drawable rewindDrawable;
    private WeakReference<ImageButton> startPauseButton;
    private WeakReference<ImageButton> ffwdButton;
    private WeakReference<ImageButton> rewButton;
    private WeakReference<ImageButton> fullscreenButton;
    private WeakReference<TextView> playbackSpeedButton;
    private WeakReference<OrientationHelper> orientationHelper;
    private WeakReference<VideoMediaPlayer> videoMediaPlayer;

    ButtonHelper(Context context, ImageButton startPauseButton, ImageButton ffwdButton, ImageButton rewButton, ImageButton fullscreenButton, TextView playbackSpeedButton) {
        this.exitFullscreenDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_fullscreen_exit_white_48dp);
        this.enterFullscreenDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_fullscreen_white_48dp);
        this.playDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_play_arrow_white_48dp);
        this.pauseDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_pause_white_48dp);
        this.fastForwardDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_fast_forward_white_48dp);
        this.rewindDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_fast_rewind_white_48dp);
        this.startPauseButton = new WeakReference<ImageButton>(startPauseButton);
        this.ffwdButton = new WeakReference<ImageButton>(ffwdButton);
        this.rewButton = new WeakReference<ImageButton>(rewButton);
        this.fullscreenButton = new WeakReference<ImageButton>(fullscreenButton);
        this.playbackSpeedButton = new WeakReference<TextView>(playbackSpeedButton);
    }

    public void setupDrawables(TypedArray typedArray) {
        this.setupPlayPauseButton(typedArray);
        this.setupFullscreenButton(typedArray);
        this.setupRewindButton(typedArray);
        this.setupFastForwardButton(typedArray);
    }

    private void setupFastForwardButton(TypedArray a) {
        Drawable drawable2 = a.getDrawable(R.styleable.VideoControllerView_ffwd_drawable);
        if (drawable2 != null) {
            this.fastForwardDrawable = drawable2;
        }
        ((ImageButton)this.ffwdButton.get()).setImageDrawable(this.fastForwardDrawable);
    }

    private void setupRewindButton(TypedArray a) {
        Drawable drawable2 = a.getDrawable(R.styleable.VideoControllerView_rew_drawable);
        if (drawable2 != null) {
            this.rewindDrawable = drawable2;
        }
        ((ImageButton)this.rewButton.get()).setImageDrawable(this.rewindDrawable);
    }

    private void setupFullscreenButton(TypedArray a) {
        Drawable enterDrawable = a.getDrawable(R.styleable.VideoControllerView_enter_fullscreen_drawable);
        if (enterDrawable != null) {
            this.enterFullscreenDrawable = enterDrawable;
        }
        ((ImageButton)this.fullscreenButton.get()).setImageDrawable(this.enterFullscreenDrawable);
        Drawable exitDrawable = a.getDrawable(R.styleable.VideoControllerView_exit_fullscreen_drawable);
        if (exitDrawable != null) {
            this.setExitFullscreenDrawable(exitDrawable);
        }
    }

    private void setupPlayPauseButton(TypedArray a) {
        Drawable drawable2 = a.getDrawable(R.styleable.VideoControllerView_play_drawable);
        if (drawable2 != null) {
            this.playDrawable = drawable2;
        }
        ((ImageButton)this.startPauseButton.get()).setImageDrawable(this.playDrawable);
        Drawable drawable1 = a.getDrawable(R.styleable.VideoControllerView_pause_drawable);
        if (drawable1 != null) {
            this.pauseDrawable = drawable1;
        }
    }

    public void setEnterFullscreenDrawable(Drawable enterFullscreenDrawable) {
        if (enterFullscreenDrawable != null) {
            this.enterFullscreenDrawable = enterFullscreenDrawable;
        }
    }

    public void setExitFullscreenDrawable(Drawable exitFullscreenDrawable) {
        if (exitFullscreenDrawable != null) {
            this.exitFullscreenDrawable = exitFullscreenDrawable;
        }
    }

    public void setPlayDrawable(Drawable playDrawable) {
        if (playDrawable != null) {
            this.playDrawable = playDrawable;
        }
    }

    public void setPauseDrawable(Drawable pauseDrawable) {
        if (pauseDrawable != null) {
            this.pauseDrawable = pauseDrawable;
        }
    }

    public void setFastForwardDrawable(Drawable fastForwardDrawable) {
        this.fastForwardDrawable = fastForwardDrawable;
    }

    public void setRewindDrawable(Drawable rewindDrawable) {
        this.rewindDrawable = rewindDrawable;
    }

    public void updateRewindDrawable() {
        if (this.rewButton.get() == null || this.videoMediaPlayer.get() == null) {
            return;
        }
        ((ImageButton)this.rewButton.get()).setImageDrawable(this.rewindDrawable);
    }

    public void updateFastForwardDrawable() {
        if (this.ffwdButton.get() == null || this.videoMediaPlayer.get() == null) {
            return;
        }
        ((ImageButton)this.ffwdButton.get()).setImageDrawable(this.fastForwardDrawable);
    }

    public void updatePausePlay() {
        if (this.startPauseButton.get() == null || this.videoMediaPlayer.get() == null) {
            return;
        }
        if (((VideoMediaPlayer)((Object)this.videoMediaPlayer.get())).isPlaying()) {
            ((ImageButton)this.startPauseButton.get()).setImageDrawable(this.pauseDrawable);
        } else {
            ((ImageButton)this.startPauseButton.get()).setImageDrawable(this.playDrawable);
        }
    }

    public void updateFullScreenDrawable() {
        if (this.fullscreenButton.get() == null || this.orientationHelper.get() == null) {
            return;
        }
        if (((OrientationHelper)((Object)this.orientationHelper.get())).isLandscape()) {
            ((ImageButton)this.fullscreenButton.get()).setImageDrawable(this.exitFullscreenDrawable);
        } else {
            ((ImageButton)this.fullscreenButton.get()).setImageDrawable(this.enterFullscreenDrawable);
        }
    }

    public void setOrientationHelper(OrientationHelper orientationHelper) {
        this.orientationHelper = new WeakReference<OrientationHelper>(orientationHelper);
    }

    public void setVideoMediaPlayer(VideoMediaPlayer videoMediaPlayer) {
        this.videoMediaPlayer = new WeakReference<VideoMediaPlayer>(videoMediaPlayer);
    }

    public void updatePlaybackSpeedText(String text) {
        ((TextView)this.playbackSpeedButton.get()).setText((CharSequence)text);
    }
}

