/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview;

import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.SurfaceView;
import android.view.ViewGroup;
import android.widget.FrameLayout;

class VideoSurfaceView
extends SurfaceView {
    private int previousHeight;
    private int previousWidth;

    public VideoSurfaceView(Context context) {
        super(context);
    }

    public VideoSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public VideoSurfaceView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void updateLayoutParams(int videoWidth, int videoHeight) {
        this.previousHeight = this.getLayoutParams().height;
        this.previousWidth = this.getLayoutParams().width;
        DisplayMetrics displayMetrics = this.getContext().getResources().getDisplayMetrics();
        int screenWidth = displayMetrics.widthPixels;
        int screenHeight = displayMetrics.heightPixels;
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.getLayoutParams();
        if (videoHeight / screenHeight > videoWidth / screenWidth) {
            lp.height = screenHeight;
            lp.width = (int)((float)videoWidth / (float)videoHeight * (float)screenHeight);
        } else {
            lp.width = screenWidth;
            lp.height = (int)((float)videoHeight / (float)videoWidth * (float)screenWidth);
        }
        lp.gravity = 17;
        this.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    public void resetLayoutParams() {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.getLayoutParams();
        layoutParams.height = this.previousHeight;
        layoutParams.width = this.previousWidth;
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }
}

