/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.media.MediaPlayer;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import bg.devlabs.fullscreenvideoview.Builder;
import bg.devlabs.fullscreenvideoview.R;
import bg.devlabs.fullscreenvideoview.VideoControllerView;
import bg.devlabs.fullscreenvideoview.VideoMediaPlayer;
import bg.devlabs.fullscreenvideoview.VideoSurfaceView;
import bg.devlabs.fullscreenvideoview.orientation.OrientationDelegate;
import java.io.File;
import java.io.IOException;

public class FullscreenVideoView
extends FrameLayout {
    private VideoSurfaceView surfaceView;
    private SurfaceHolder surfaceHolder;
    private SurfaceHolder.Callback surfaceHolderCallback;
    private ProgressBar progressBar;
    private VideoControllerView controller;
    private VideoMediaPlayer videoMediaPlayer;
    private boolean isMediaPlayerPrepared;
    private Builder builder;
    private MediaPlayer.OnPreparedListener onPreparedListener;
    private View.OnTouchListener onTouchListener;
    private OrientationDelegate orientationDelegate;

    public FullscreenVideoView(@NonNull Context context) {
        super(context);
    }

    public FullscreenVideoView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public FullscreenVideoView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.findChildViews();
        if (!this.isInEditMode()) {
            this.videoMediaPlayer = new VideoMediaPlayer(this);
            this.initOrientationHandlers();
        }
        this.surfaceHolderCallback = new SurfaceHolderCallback();
        this.surfaceHolder = this.surfaceView.getHolder();
        this.surfaceHolder.addCallback(this.surfaceHolderCallback);
        this.controller.init(this, this.videoMediaPlayer, attrs);
        this.setupProgressBarColor();
        this.initOnBackPressedListener();
        this.setupOnTouchListener();
        this.onPreparedListener = new VideoOnPreparedListener();
    }

    private void initOrientationHandlers() {
        if (!this.isInEditMode()) {
            this.orientationDelegate = new VideoOrientationDelegate();
            this.orientationDelegate.enable();
        }
    }

    private void findChildViews() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        layoutInflater.inflate(R.layout.fullscreen_video_view, (ViewGroup)this, true);
        this.surfaceView = (VideoSurfaceView)this.findViewById(R.id.surface_view);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progress_bar);
        this.controller = (VideoControllerView)this.findViewById(R.id.video_controller);
    }

    private void initOnBackPressedListener() {
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.setOnKeyListener(new VideoOnKeyListener());
    }

    public Builder videoFile(File videoFile) {
        this.builder = new Builder(this, this.controller, this.orientationDelegate, this.videoMediaPlayer);
        this.builder.videoFile(videoFile);
        return this.builder;
    }

    public Builder videoUrl(String videoUrl) {
        this.builder = new Builder(this, this.controller, this.orientationDelegate, this.videoMediaPlayer);
        this.builder.videoUrl(videoUrl);
        return this.builder;
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (newConfig.orientation == 2) {
            this.orientationDelegate.activateFullscreen();
        } else if (newConfig.orientation == 1) {
            this.orientationDelegate.exitFullscreen();
        }
    }

    protected void onDetachedFromWindow() {
        this.handleOnDetach();
        super.onDetachedFromWindow();
    }

    private void handleOnDetach() {
        Log.d((String)FullscreenVideoView.class.getSimpleName(), (String)"onDetachedFromWindow: ");
        this.controller.onDetach();
        if (this.orientationDelegate != null) {
            this.orientationDelegate.disable();
        }
        if (this.videoMediaPlayer != null) {
            this.videoMediaPlayer.onDetach();
        }
        if (this.surfaceHolder != null) {
            this.surfaceHolder.removeCallback(this.surfaceHolderCallback);
            this.surfaceHolder.getSurface().release();
        }
        if (this.surfaceView != null) {
            this.surfaceView.invalidate();
            this.surfaceView.destroyDrawingCache();
        }
        this.controller = null;
        this.orientationDelegate = null;
        this.videoMediaPlayer = null;
        this.surfaceHolder = null;
        this.surfaceView = null;
        this.onTouchListener = null;
        this.onPreparedListener = null;
        this.progressBar = null;
        this.setOnKeyListener(null);
        this.setOnTouchListener(null);
    }

    void setupMediaPlayer(String videoPath) {
        try {
            this.showProgress();
            this.videoMediaPlayer.setAudioStreamType(3);
            this.videoMediaPlayer.setDataSource(videoPath);
            this.videoMediaPlayer.setOnPreparedListener(this.onPreparedListener);
            this.videoMediaPlayer.prepareAsync();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setupOnTouchListener() {
        this.onTouchListener = new VideoOnTouchListener();
        this.setOnTouchListener(this.onTouchListener);
    }

    private void setupProgressBarColor() {
        int shortAnimTime = this.getResources().getInteger(0x10E0000);
        this.progressBar.animate().setDuration((long)shortAnimTime);
    }

    private void hideProgress() {
        this.progressBar.setVisibility(4);
    }

    private void showProgress() {
        this.progressBar.setVisibility(0);
    }

    boolean isLandscape() {
        return this.orientationDelegate.isLandscape();
    }

    void toggleFullscreen() {
        this.orientationDelegate.toggleFullscreen();
    }

    void enableAutoStart() {
        this.videoMediaPlayer.enableAutoStart();
    }

    private class SurfaceHolderCallback
    implements SurfaceHolder.Callback {
        private SurfaceHolderCallback() {
        }

        public void surfaceCreated(SurfaceHolder holder) {
            if (FullscreenVideoView.this.videoMediaPlayer != null) {
                FullscreenVideoView.this.videoMediaPlayer.setDisplay(FullscreenVideoView.this.surfaceHolder);
            }
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            if (FullscreenVideoView.this.videoMediaPlayer != null && FullscreenVideoView.this.isMediaPlayerPrepared) {
                FullscreenVideoView.this.videoMediaPlayer.pause();
            }
        }
    }

    private class VideoOnTouchListener
    implements View.OnTouchListener {
        private VideoOnTouchListener() {
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            view.performClick();
            FullscreenVideoView.this.controller.show();
            return false;
        }
    }

    private class VideoOrientationDelegate
    extends OrientationDelegate {
        VideoOrientationDelegate() {
            super(FullscreenVideoView.this.getContext(), FullscreenVideoView.this);
        }

        @Override
        public void onOrientationChanged() {
            FullscreenVideoView.this.controller.updateFullScreenDrawable();
            if (FullscreenVideoView.this.orientationDelegate.isLandscape()) {
                FullscreenVideoView.this.surfaceView.resetLayoutParams();
            } else {
                FullscreenVideoView.this.surfaceView.updateLayoutParams(FullscreenVideoView.this.videoMediaPlayer.getVideoWidth(), FullscreenVideoView.this.videoMediaPlayer.getVideoHeight());
            }
        }
    }

    private class VideoOnPreparedListener
    implements MediaPlayer.OnPreparedListener {
        private VideoOnPreparedListener() {
        }

        public void onPrepared(MediaPlayer mediaPlayer) {
            Log.d((String)FullscreenVideoView.class.getSimpleName(), (String)"onPrepared: ");
            if (!((Activity)FullscreenVideoView.this.getContext()).isDestroyed()) {
                FullscreenVideoView.this.hideProgress();
                int videoWidth = FullscreenVideoView.this.videoMediaPlayer.getVideoWidth();
                int videoHeight = FullscreenVideoView.this.videoMediaPlayer.getVideoHeight();
                FullscreenVideoView.this.surfaceView.updateLayoutParams(videoWidth, videoHeight);
                if (mediaPlayer != null && FullscreenVideoView.this.videoMediaPlayer.isAutoStartEnabled()) {
                    FullscreenVideoView.this.isMediaPlayerPrepared = true;
                    mediaPlayer.start();
                }
            }
        }
    }

    private class VideoOnKeyListener
    implements View.OnKeyListener {
        private VideoOnKeyListener() {
        }

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            return event.getAction() == 1 && keyCode == 4 && FullscreenVideoView.this.orientationDelegate.shouldHandleOnBackPressed();
        }
    }
}

