/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.functions.agent.functionIntantiation;

import be.ugent.idlab.knows.functions.agent.Agent;
import be.ugent.idlab.knows.functions.agent.Arguments;
import be.ugent.idlab.knows.functions.agent.dataType.ArrayConverter;
import be.ugent.idlab.knows.functions.agent.dataType.CollectionConverter;
import be.ugent.idlab.knows.functions.agent.dataType.DataTypeConverter;
import be.ugent.idlab.knows.functions.agent.dataType.DataTypeConverterProvider;
import be.ugent.idlab.knows.functions.agent.functionIntantiation.ThrowableFunction;
import be.ugent.idlab.knows.functions.agent.functionIntantiation.exception.ClassNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionIntantiation.exception.CompositionReferenceException;
import be.ugent.idlab.knows.functions.agent.functionIntantiation.exception.CyclicDependencyException;
import be.ugent.idlab.knows.functions.agent.functionIntantiation.exception.FunctionNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionIntantiation.exception.InstantiationException;
import be.ugent.idlab.knows.functions.agent.functionIntantiation.exception.MethodNotFoundException;
import be.ugent.idlab.knows.functions.agent.functionIntantiation.exception.NotACompositeFunctionException;
import be.ugent.idlab.knows.functions.agent.model.CompositionMappingElement;
import be.ugent.idlab.knows.functions.agent.model.CompositionMappingPoint;
import be.ugent.idlab.knows.functions.agent.model.Function;
import be.ugent.idlab.knows.functions.agent.model.FunctionComposition;
import be.ugent.idlab.knows.functions.agent.model.FunctionFieldPair;
import be.ugent.idlab.knows.functions.agent.model.FunctionMapping;
import be.ugent.idlab.knows.functions.agent.model.Parameter;
import be.ugent.idlab.knows.misc.FileFinder;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Instantiator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Function> id2functionMap;
    private final Map<String, Method> id2MethodMap = new HashMap<String, Method>();
    private final Map<String, ThrowableFunction> id2CompositionLambdaMap = new HashMap<String, ThrowableFunction>();
    private final Map<String, Class<?>> className2ClassMap = new HashMap();
    private final DataTypeConverterProvider dataTypeConverterProvider;

    public Instantiator(Map<String, Function> functions, DataTypeConverterProvider dataTypeConverterProvider) {
        this.id2functionMap = functions;
        this.dataTypeConverterProvider = dataTypeConverterProvider;
    }

    public Method getMethod(String functionId) throws InstantiationException {
        this.logger.debug("Getting instantiation for {}", (Object)functionId);
        if (this.id2MethodMap.containsKey(functionId)) {
            this.logger.debug("Method for {} found in cache.", (Object)functionId);
            return this.id2MethodMap.get(functionId);
        }
        if (this.id2functionMap.containsKey(functionId)) {
            Function function = this.id2functionMap.get(functionId);
            FunctionMapping mapping = function.getFunctionMapping();
            String location = mapping.getImplementation().getLocation();
            String className = mapping.getImplementation().getClassName();
            Class<?> clazz = this.getClass(className, location);
            this.logger.debug("Found class {}", clazz);
            String methodName = mapping.getMethodMapping().getMethodName();
            List<Parameter> parameters = function.getArgumentParameters();
            try {
                Parameter p = function.getReturnParameters().size() == 0 ? new Parameter("", "", this.dataTypeConverterProvider.getDataTypeConverter("void"), true) : function.getReturnParameters().get(0);
                Method method = this.getMethod(clazz, methodName, parameters, p);
                this.logger.debug("Found method {}", (Object)method.getName());
                this.id2MethodMap.put(functionId, method);
                return method;
            }
            catch (java.lang.ClassNotFoundException e) {
                throw new ClassNotFoundException(e.getMessage());
            }
        }
        throw new FunctionNotFoundException("No function found with id " + functionId);
    }

    public ThrowableFunction getCompositeMethod(String functionId, boolean debug) throws InstantiationException {
        this.logger.debug("constructing composite method for {}", (Object)functionId);
        if (this.id2CompositionLambdaMap.containsKey(functionId)) {
            this.logger.debug("found composition for {} in cache!", (Object)functionId);
            return this.id2CompositionLambdaMap.get(functionId);
        }
        if (!this.id2functionMap.containsKey(functionId)) {
            throw new FunctionNotFoundException("No function found with id " + functionId);
        }
        Function function = this.id2functionMap.get(functionId);
        if (!function.isComposite()) {
            throw new NotACompositeFunctionException("the provided functionId is not a function composition");
        }
        FunctionComposition functionComposition = function.getFunctionComposition();
        HashMap<String, Map> values = new HashMap<String, Map>();
        ArrayListValuedHashMap dependencies = new ArrayListValuedHashMap();
        ArrayListValuedHashMap parametermap = new ArrayListValuedHashMap();
        ArrayListValuedHashMap globalDependencies = new ArrayListValuedHashMap();
        for (CompositionMappingElement el : functionComposition.getMappings()) {
            CompositionMappingPoint from = el.getFrom();
            CompositionMappingPoint to = el.getTo();
            if (from.isLiteral()) {
                Map functionValues = values.getOrDefault(to.getFunctionId(), new HashMap());
                functionValues.put(to.getParameterId(), from.getParameterId());
                values.put(to.getFunctionId(), functionValues);
                continue;
            }
            this.checkFunction(from);
            this.checkFunction(to);
            parametermap.put((Object)new FunctionFieldPair(to.getFunctionId(), to.getParameterId()), (Object)new FunctionFieldPair(from.getFunctionId(), from.getParameterId()));
            if (!from.isOutput()) continue;
            dependencies.put((Object)to.getFunctionId(), (Object)from.getFunctionId());
        }
        for (String funcId : dependencies.keySet()) {
            ArrayList list = new ArrayList(dependencies.get((Object)funcId));
            Collection deps = globalDependencies.get((Object)funcId);
            while (!list.isEmpty()) {
                ArrayList toAdd = new ArrayList();
                for (String dep : list) {
                    List tmpdep = dependencies.get((Object)dep).stream().filter(i -> !deps.contains(i)).filter(i -> !toAdd.contains(i)).collect(Collectors.toList());
                    toAdd.addAll(tmpdep);
                }
                deps.addAll(list);
                list.clear();
                list.addAll(toAdd);
                toAdd.clear();
            }
        }
        this.checkDependencyCycles((MultiValuedMap<String, String>)globalDependencies);
        ArrayDeque<String> execStack = new ArrayDeque<String>();
        ArrayDeque<String> toadd = new ArrayDeque<String>();
        toadd.add(functionId);
        while (!toadd.isEmpty()) {
            String fId = (String)toadd.poll();
            Collection dep = dependencies.get((Object)fId);
            if (toadd.stream().anyMatch(arg_0 -> Instantiator.lambda$getCompositeMethod$2((MultiValuedMap)globalDependencies, fId, arg_0))) {
                toadd.add(fId);
                continue;
            }
            execStack.push(fId);
            dep.stream().filter(funcName -> !execStack.contains(funcName)).forEach(toadd::add);
        }
        execStack.removeLast();
        if (debug) {
            Queue sideSet = dependencies.keySet().stream().filter(name -> !execStack.contains(name)).collect(Collectors.toCollection(ArrayDeque::new));
            while (!sideSet.isEmpty()) {
                String s = (String)sideSet.poll();
                if (execStack.containsAll(dependencies.get((Object)s))) {
                    execStack.addLast(s);
                    continue;
                }
                sideSet.add(s);
            }
        }
        ThrowableFunction returnFunction = (arg_0, arg_1) -> this.lambda$getCompositeMethod$6(function, values, functionId, execStack, (MultiValuedMap)parametermap, arg_0, arg_1);
        this.id2CompositionLambdaMap.put(functionId, returnFunction);
        return returnFunction;
    }

    private void checkFunction(CompositionMappingPoint compositionMappingPoint) throws InstantiationException {
        Function fromFunction = this.id2functionMap.get(compositionMappingPoint.getFunctionId());
        if (Objects.isNull(fromFunction)) {
            throw new CompositionReferenceException("the used function " + compositionMappingPoint.getFunctionId() + " could not be found");
        }
        List<Parameter> fromInputParameters = fromFunction.getArgumentParameters();
        List<Parameter> fromReturnParameters = fromFunction.getReturnParameters();
        String parameterId = compositionMappingPoint.getParameterId();
        if (fromInputParameters.stream().map(Parameter::getId).noneMatch(id -> Objects.equals(id, parameterId)) && fromReturnParameters.stream().map(Parameter::getId).noneMatch(id -> Objects.equals(id, parameterId))) {
            throw new CompositionReferenceException("the used parameter " + parameterId + " of function " + compositionMappingPoint.getFunctionId() + " could not be found");
        }
    }

    private void checkDependencyCycles(MultiValuedMap<String, String> globalDependencies) throws InstantiationException {
        for (String functionID : globalDependencies.keySet()) {
            if (!globalDependencies.get((Object)functionID).contains(functionID)) continue;
            throw new CyclicDependencyException("Cycle detected in dependency of " + functionID);
        }
    }

    private Class<?> getClass(String className, String location) throws ClassNotFoundException {
        this.logger.debug("Trying to find a Class for {}", (Object)className);
        if (this.className2ClassMap.containsKey(className)) {
            return this.className2ClassMap.get(className);
        }
        try {
            Class<?> cls = Class.forName(className);
            this.className2ClassMap.put(className, cls);
            return cls;
        }
        catch (java.lang.ClassNotFoundException e) {
            this.logger.debug("Class '{}' not found by current class loader. Checking location '{}'", (Object)className, (Object)location);
            URL locationUrl = FileFinder.findFile(location);
            this.logger.debug("Trying to load '{}' for JAR file '{}'", (Object)className, (Object)location);
            try {
                this.loadClassesFromJAR(locationUrl);
                if (this.className2ClassMap.containsKey(className)) {
                    return this.className2ClassMap.get(className);
                }
                this.logger.warn("No class '{}' found in JAR file '{}'", (Object)className, (Object)locationUrl);
            }
            catch (IOException ex) {
                this.logger.warn("An error occurred trying to load classes of file '{}'. Note that only JAR files are supported at the moment.", (Object)locationUrl, (Object)ex);
            }
            throw new ClassNotFoundException("No class found for " + className);
        }
    }

    private Method getMethod(Class<?> clazz, String methodName, List<Parameter> expectedParameters, Parameter expectedReturnParameter) throws MethodNotFoundException, java.lang.ClassNotFoundException {
        Method[] methods;
        this.logger.debug("Trying to find method with name {}", (Object)methodName);
        for (Method method : methods = clazz.getMethods()) {
            boolean qualifies = false;
            if (method.getName().equals(methodName) && method.getParameterCount() == expectedParameters.size()) {
                qualifies = true;
                this.logger.debug("Found method with matching name {} and matching parameter count ({})", (Object)methodName, (Object)expectedParameters.size());
                Type[] parameterTypes = method.getGenericParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Type parameterType = parameterTypes[i];
                    Class<?> methodParameterClass = method.getParameterTypes()[i];
                    DataTypeConverter<?> dataTypeConverter = expectedParameters.get(i).getTypeConverter();
                    if (dataTypeConverter.isSubTypeOf(methodParameterClass)) {
                        if (dataTypeConverter.getTypeCategory() != DataTypeConverter.TypeCategory.COLLECTION) continue;
                        if (parameterType instanceof ParameterizedType) {
                            ParameterizedType pType = (ParameterizedType)parameterType;
                            Type[] typeArgs = pType.getActualTypeArguments();
                            DataTypeConverter<?> argumentDataTypeConverter = this.dataTypeConverterProvider.getDataTypeConverterWhichProcessesSubTypeOf(typeArgs[0].getTypeName());
                            ((CollectionConverter)dataTypeConverter).setArgumentTypeConverter(argumentDataTypeConverter);
                            continue;
                        }
                        if (methodParameterClass.isArray()) {
                            Class<?> componentType = methodParameterClass.getComponentType();
                            ArrayConverter arrayConverter = new ArrayConverter();
                            arrayConverter.setArgumentTypeConverter(this.dataTypeConverterProvider.getDataTypeConverterWhichProcessesSubTypeOf(componentType.getTypeName()));
                            expectedParameters.get(i).setTypeConverter(arrayConverter);
                            continue;
                        }
                        Set<String> interfaces = DataTypeConverter.getSuperTypesOf(methodParameterClass);
                        if (interfaces.contains(Collection.class.getName())) continue;
                        throw new MethodNotFoundException("No suitable data type converter found for class '" + clazz.getName() + "', method '" + methodName + "', parameter '" + expectedParameters.get(i).getName() + "' which should be of type '" + parameterType.getTypeName() + "'.");
                    }
                    qualifies = false;
                    break;
                }
                Class<?>[] methodParameterTypes = method.getParameterTypes();
                for (int i = 0; i < methodParameterTypes.length; ++i) {
                    Class<?> methodParameterType = methodParameterTypes[i];
                    if (expectedParameters.get(i).getTypeConverter().isSubTypeOf(methodParameterType)) continue;
                    qualifies = false;
                    break;
                }
            }
            if (!qualifies) continue;
            this.logger.debug("Found method by name and expected arguments. Checking return type...");
            Class<?> methodReturnType = method.getReturnType();
            if (expectedReturnParameter.getTypeConverter().isSuperTypeOf(methodReturnType)) {
                this.logger.debug("Found method!");
                return method;
            }
            this.logger.warn("Return type '{}' of method '{}' does not match expeted return type '{}' (class '{}')", new Object[]{methodReturnType.getName(), method.getName(), expectedReturnParameter.getTypeConverter().getTypeClass(), clazz.getName()});
        }
        throw new MethodNotFoundException("No suitable method '" + methodName + "' with matching parameter types found in class '" + clazz.getName() + "'.");
    }

    private void loadClassesFromJAR(URL jarFileUrl) throws IOException {
        try (JarFile jarFile = new JarFile(URLDecoder.decode(jarFileUrl.getPath(), StandardCharsets.UTF_8));
             URLClassLoader cl = URLClassLoader.newInstance(new URL[]{jarFileUrl});){
            jarFile.stream().map(ZipEntry::getName).filter(name -> name.endsWith(".class") && !name.contains("$")).map(name -> name.substring(0, name.lastIndexOf(46)).replaceAll("/", ".")).forEach(className -> {
                this.logger.debug("JAR file '{}': found class name '{}'", (Object)jarFileUrl, className);
                if (!this.className2ClassMap.containsKey(className)) {
                    try {
                        Class<?> cls = Class.forName(className, true, cl);
                        this.className2ClassMap.put((String)className, cls);
                    }
                    catch (java.lang.ClassNotFoundException e) {
                        this.logger.warn("Class '{}' in JAR file '{}'", new Object[]{className, jarFileUrl, e});
                    }
                } else {
                    this.logger.debug("Class '{}' already in cache.", className);
                }
            });
        }
    }

    public void close() {
        this.className2ClassMap.values().forEach(clazz -> {
            Method[] methods;
            for (Method method : methods = clazz.getMethods()) {
                if (!method.getName().equals("close") || method.getParameterCount() != 0) continue;
                try {
                    this.logger.debug("Closing {}", (Object)clazz.getName());
                    method.invoke(null, new Object[0]);
                }
                catch (Throwable e) {
                    this.logger.debug("Cannot close {}", (Object)clazz.getName());
                }
                break;
            }
        });
    }

    private /* synthetic */ Object lambda$getCompositeMethod$6(Function function, Map values, String functionId, Deque execStack, MultiValuedMap parametermap, Agent agent, Object[] args) throws Exception {
        List<Parameter> fArgs = function.getArgumentParameters();
        for (int i = 0; i < fArgs.size(); ++i) {
            Parameter p = fArgs.get(i);
            Object value = args[i];
            Map vals = values.getOrDefault(functionId, new HashMap());
            vals.put(p.getId(), value);
            values.put(functionId, vals);
        }
        while (!execStack.isEmpty()) {
            String f = (String)execStack.pop();
            Arguments arguments = new Arguments();
            Function func = this.id2functionMap.get(f);
            for (Parameter p : func.getArgumentParameters()) {
                FunctionFieldPair ffp = new FunctionFieldPair(f, p.getId());
                ArrayList ffpc = new ArrayList();
                ArrayList toAdd = new ArrayList(parametermap.get((Object)ffp));
                ArrayList willBeAdded = new ArrayList();
                while (!toAdd.isEmpty()) {
                    ffpc.addAll(toAdd);
                    for (FunctionFieldPair functionFieldPair2 : toAdd) {
                        willBeAdded.addAll(parametermap.get((Object)functionFieldPair2));
                    }
                    toAdd.clear();
                    toAdd.addAll(willBeAdded);
                    willBeAdded.clear();
                }
                if (ffpc.isEmpty()) {
                    arguments = arguments.add(p.getId(), ((Map)values.get(f)).get(p.getId()));
                }
                for (FunctionFieldPair functionFieldPair2 : ffpc) {
                    arguments = arguments.add(p.getId(), ((Map)values.get(functionFieldPair2.getFunction())).get(functionFieldPair2.getField()));
                }
            }
            Object result = agent.execute(f, arguments);
            Map functionValues = values.getOrDefault(f, new HashMap());
            functionValues.put(func.getReturnParameters().get(0).getId(), result);
            values.put(f, functionValues);
        }
        Collection returnFfp = parametermap.get((Object)new FunctionFieldPair(functionId, function.getReturnParameters().get(0).getId()));
        ArrayList returnList = new ArrayList();
        returnFfp.forEach(functionFieldPair -> returnList.add(((Map)values.get(functionFieldPair.getFunction())).get(functionFieldPair.getField())));
        return returnList.get(0);
    }

    private static /* synthetic */ boolean lambda$getCompositeMethod$2(MultiValuedMap globalDependencies, String fId, String other) {
        Collection otherDep = globalDependencies.get((Object)other);
        return otherDep.contains(fId);
    }
}

