/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.idlab.knows.functions.agent.dataType;

import be.ugent.idlab.knows.functions.agent.dataType.CollectionConverter;
import be.ugent.idlab.knows.functions.agent.dataType.DataTypeConverter;
import be.ugent.idlab.knows.functions.agent.dataType.DataTypeConverterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ListConverter
extends CollectionConverter<List> {
    public ListConverter() {
        super(List.class, DataTypeConverter.TypeCategory.COLLECTION);
    }

    @Override
    public List<?> convert(Object value) throws DataTypeConverterException {
        if (value instanceof Collection) {
            return this.convertCollection((List)value);
        }
        if (value.getClass().isArray()) {
            return this.convert(Arrays.asList((Object[])value));
        }
        throw new DataTypeConverterException("Cannot convert object of type " + value.getClass().getName() + " to a List.");
    }

    private List<?> convertCollection(Collection<?> values) throws DataTypeConverterException {
        ArrayList result = new ArrayList();
        for (Object o : values) {
            result.add(this.getArgumentTypeConverter().convert(o));
        }
        return result;
    }
}

